<?php
	/**
		*
		*
		* @package Main
		* @author e-plugin.com
	*/
	/*
		Plugin Name: Hotel Listing
		Plugin URI: http://e-plugin.com/
		Description: Build Paid listing Directory using Wordpress.No programming knowledge required.
		Author: e-plugin
		Author URI: http://e-plugin.com/
		Version: 1.4.0
		Text Domain: ivdirectories
		License: GPLv3
	*/
	// Exit if accessed directly
	if (!defined('ABSPATH')) {
		exit;
	}
	if (!class_exists('wp_iv_directories')) {
		final class wp_iv_directories {
			private static $instance;
			/**
				* The Plug-in version.
				*
				* @var string
			*/
			public $version = "1.4.0";
			/**
				* The minimal required version of WordPress for this plug-in to function correctly.
				*
				* @var string
			*/
			public $wp_version = "3.5";
			public static function instance() {
				if (!isset(self::$instance) && !(self::$instance instanceof wp_iv_directories)) {
					self::$instance = new wp_iv_directories;
				}
				return self::$instance;
			}
			/**
				* Construct and start the other plug-in functionality
			*/
			public function __construct() {
				//
				// 1. Plug-in requirements
				//
				if (!$this->check_requirements()) {
					return;
				}
				//
				// 2. Declare constants and load dependencies
				//
				$this->define_constants();
				$this->load_dependencies();
				//
				// 3. Activation Hooks
				//
				register_activation_hook(__FILE__, array($this, 'activate'));
				register_deactivation_hook(__FILE__, array($this, 'deactivate'));
				register_uninstall_hook(__FILE__, 'wp_iv_directories::uninstall');
				//
				// 4. Load Widget
				//
				add_action('widgets_init', array($this, 'register_widget'));
				//
				// 5. i18n
				//
				add_action('init', array(&$this, 'i18n'));
				//
				// 6. Actions
				//
				add_action('wp_ajax_iv_directories_user_exist_check', array($this, 'iv_directories_user_exist_check'));
				add_action('wp_ajax_nopriv_iv_directories_user_exist_check', array($this, 'iv_directories_user_exist_check'));
				add_action('wp_ajax_iv_directories_check_coupon', array($this, 'iv_directories_check_coupon'));
				add_action('wp_ajax_nopriv_iv_directories_check_coupon', array($this, 'iv_directories_check_coupon'));
				add_action('wp_ajax_iv_directories_check_package_amount', array($this, 'iv_directories_check_package_amount'));
				add_action('wp_ajax_nopriv_iv_directories_check_package_amount', array($this, 'iv_directories_check_package_amount'));
				add_action('wp_ajax_iv_directories_update_profile_pic', array($this, 'iv_directories_update_profile_pic'));
				add_action('wp_ajax_nopriv_iv_directories_update_profile_pic', array($this, 'iv_directories_update_profile_pic'));
				add_action('wp_ajax_iv_directories_update_profile_setting', array($this, 'iv_directories_update_profile_setting'));
				
				add_action('wp_ajax_iv_directories_save_listing', array($this, 'iv_directories_save_listing'));
				add_action('wp_ajax_iv_directories_update_setting_fb', array($this, 'iv_directories_update_setting_fb'));
				add_action('wp_ajax_iv_directories_update_setting_hide', array($this, 'iv_directories_update_setting_hide'));
				add_action('wp_ajax_iv_directories_update_setting_password', array($this, 'iv_directories_update_setting_password'));
				add_action('wp_ajax_iv_directories_check_login', array($this, 'iv_directories_check_login'));
				add_action('wp_ajax_nopriv_iv_directories_check_login', array($this, 'iv_directories_check_login'));
				add_action('wp_ajax_iv_directories_forget_password', array($this, 'iv_directories_forget_password'));
				add_action('wp_ajax_nopriv_iv_directories_forget_password', array($this, 'iv_directories_forget_password'));
				add_action('wp_ajax_iv_directories_cancel_stripe', array($this, 'iv_directories_cancel_stripe'));
				add_action('wp_ajax_iv_directories_cancel_paypal', array($this, 'iv_directories_cancel_paypal'));
				add_action('wp_ajax_iv_directories_profile_stripe_upgrade', array($this, 'iv_directories_profile_stripe_upgrade'));
				add_action('wp_ajax_iv_directories_save_favorite', array($this, 'iv_directories_save_favorite'));
				add_action('wp_ajax_iv_directories_save_un_favorite', array($this, 'iv_directories_save_un_favorite'));
				add_action('wp_ajax_iv_directories_save_note', array($this, 'iv_directories_save_note'));
				add_action('wp_ajax_iv_directories_delete_favorite', array($this, 'iv_directories_delete_favorite'));
				add_action('wp_ajax_iv_directories_contact_popup', array($this, 'iv_directories_contact_popup'));
				add_action('wp_ajax_nopriv_iv_directories_contact_popup', array($this, 'iv_directories_contact_popup'));
				add_action('wp_ajax_iv_directories_message_send', array($this, 'iv_directories_message_send'));
				add_action('wp_ajax_nopriv_iv_directories_message_send', array($this, 'iv_directories_message_send'));
				add_action('wp_ajax_iv_directories_claim_send', array($this, 'iv_directories_claim_send'));
				add_action('wp_ajax_nopriv_iv_directories_claim_send', array($this, 'iv_directories_claim_send'));
				add_action('wp_ajax_iv_directories_cron_job', array($this, 'iv_directories_cron_job'));
				add_action('wp_ajax_nopriv_iv_directories_cron_job', array($this, 'iv_directories_cron_job'));
				add_action('wp_ajax_iv_directories_update_listing', array($this, 'iv_directories_update_listing'));
				add_action('wp_ajax_iv_directories_cpt_change', array($this, 'iv_directories_cpt_change'));
				add_action('wp_ajax_iv_directories_save_rating', array($this, 'iv_directories_save_rating'));
				add_action('wp_ajax_nopriv_iv_directories_save_rating', array($this, 'iv_directories_save_rating'));
				add_action('wp_ajax_iv_directories_booking_send', array(&$this, 'iv_directories_booking_send'));
				add_action('wp_ajax_nopriv_iv_directories_booking_send', array(&$this, 'iv_directories_booking_send'));
				add_action('wp_ajax_finalerp_csv_product_upload', array($this, 'finalerp_csv_product_upload'));
				add_action('wp_ajax_save_csv_file_to_database', array($this, 'save_csv_file_to_database'));
				add_action('wp_ajax_eppro_get_import_status', array($this, 'eppro_get_import_status'));
				add_action('plugins_loaded', array($this, 'start'));
				add_action('add_meta_boxes', array($this, 'prfx_custom_meta_iv_listing'));
				add_action('save_post', array($this, 'iv_listing_meta_save'));
				add_action( 'init', array($this, 'iv_directories_paypal_form_submit') );
				add_action( 'init', array($this, 'iv_directories_stripe_form_submit') );
				add_action('wp_login', array($this, 'check_expiry_date'));
				add_action('pre_get_posts',array($this, 'iv_restrict_media_library') );
				add_action( 'wp_loaded', array($this, 'iv_directories_woocommerce_form_submit') );
				// For Visual Composer
				add_action('vc_before_init',array($this, 'dir_vc_pricing_table') );
				add_action('vc_before_init',array($this, 'dir_vc_signup') );
				add_action('vc_before_init',array($this, 'dir_vc_user_login') );
				add_action('vc_before_init',array($this, 'dir_vc_my_account') );
				add_action('vc_before_init',array($this, 'dir_vc_public_profile') );
				add_action('vc_before_init',array($this, 'dir_vc_user_directory') );
				//VC Single listing elements
				add_action('vc_before_init',array($this, 'dir_vc_listing_slider') );
				add_action('vc_before_init',array($this, 'dir_vc_listing_feature_image') );
				add_action('vc_before_init',array($this, 'dir_vc_listing_contact_info') );
				add_action('vc_before_init',array($this, 'dir_vc_listing_social_profile') );
				add_action('vc_before_init',array($this, 'dir_vc_listing_about_us') );
				add_action('vc_before_init',array($this, 'dir_vc_listing_about_us_fields') );
				add_action('vc_before_init',array($this, 'dir_vc_listing_Specialitiess') );
				add_action('vc_before_init',array($this, 'dir_vc_listing_awards') );
				add_action('vc_before_init',array($this, 'dir_vc_listing_video') );
				add_action('vc_before_init',array($this, 'dir_vc_listing_event') );
				add_action('vc_before_init',array($this, 'dir_vc_listing_reviews') );
				add_action('vc_before_init',array($this, 'dir_vc_listing_working_time') );
				add_action('vc_before_init',array($this, 'dir_vc_listing_contact_us') );
				add_action('vc_before_init',array($this, 'dir_vc_listing_claim') );
				add_action('vc_before_init',array($this, 'dir_vc_listing_share_it') );
				add_action('vc_before_init',array($this, 'dir_vc_listing_map') );
				add_action('vc_before_init',array($this, 'dir_vc_listing_logo') );
				add_action('vc_before_init',array($this, 'dir_vc_listing_comments') );
				add_action('vc_before_init',array($this, 'dir_vc_listing_tag') );
				add_action('vc_before_init',array($this, 'dir_vc_listing_doc') );
				// 7. Shortcode
				add_shortcode('iv_directories_search', array($this, 'iv_directories_search_func'));
				add_shortcode('iv_archive_directories', array($this, 'iv_archive_directories_func'));
				add_shortcode('iv_directories_price_table', array($this, 'iv_directories_price_table_func'));
				add_shortcode('iv_directories_form_wizard', array($this, 'iv_directories_form_wizard_func'));
				add_shortcode('iv_directories_profile_template', array($this, 'iv_directories_profile_template_func'));
				add_shortcode('iv_directories_profile_public', array($this, 'iv_directories_profile_public_func'));
				add_shortcode('iv_directories_login', array($this, 'iv_directories_login_func'));
				add_shortcode('iv_directories_user_directory', array($this, 'iv_directories_user_directory_func'));
				add_shortcode('listing_categories', array($this, 'listing_categories_func'));
				add_shortcode('listing_categories_tree', array($this, 'listing_categories_tree_func'));
				add_shortcode('listing_featured', array($this, 'listing_featured_func'));
				add_shortcode('listing_archive_layout', array($this, 'listing_archive_layout_func'));
				add_shortcode('listing_archive', array($this, 'listing_archive_func'));
				add_shortcode('listing_grid_filter', array($this, 'listing_grid_filter_func'));
				add_shortcode('listing_grid_alphabet', array($this, 'listing_grid_alphabet_func'));
				add_shortcode('listing_filter', array($this, 'listing_filter_func'));
				add_shortcode('hd_search_box', array($this, 'hd_search_box_func'));
				add_shortcode('listing_cities', array($this, 'listing_cities_func'));
				// VC  shortcode
				add_shortcode('iv_listing_slider', array($this, 'listing_slider_func'));
				add_shortcode('iv_listing_feature_image', array($this, 'listing_feature_image_func'));
				add_shortcode('iv_listing_contact_info', array($this, 'listing_contact_info_func'));
				add_shortcode('iv_listing_social_profile', array($this, 'listing_social_profile_func'));
				add_shortcode('iv_listing_about_us', array($this, 'listing_about_us_func'));
				add_shortcode('iv_listing_about_us_fields', array($this, 'listing_about_us_fields_func'));
				add_shortcode('iv_listing_Specialitiess', array($this, 'listing_Specialitiess_func'));
				add_shortcode('iv_listing_awards', array($this, 'listing_awards_func'));
				add_shortcode('iv_listing_video', array($this, 'listing_video_func'));
				add_shortcode('iv_listing_event', array($this, 'listing_event_func'));
				add_shortcode('iv_listing_reviews', array($this, 'listing_reviews_func'));
				add_shortcode('iv_listing_working_time', array($this, 'listing_working_time_func'));
				add_shortcode('iv_listing_contact_us', array($this, 'listing_contact_us_func'));
				add_shortcode('iv_listing_claim', array($this, 'listing_claim_func'));
				add_shortcode('iv_listing_share_it', array($this, 'listing_share_it_func'));
				add_shortcode('iv_listing_map', array($this, 'listing_map_func'));
				add_shortcode('iv_listing_logo', array($this, 'listing_logo_func'));
				add_shortcode('iv_listing_comments', array($this, 'listing_comments_func'));
				add_shortcode('iv_listing_tag', array($this, 'listing_tag_func'));
				add_shortcode('iv_listing_doc', array($this, 'listing_doc_func'));
				add_shortcode('iv_directories_reminder_email_cron', array($this, 'iv_directories_reminder_email_cron_func'));
				// 8. Filter
				add_filter('user_contactmethods', array($this, 'modify_contact_methods') );

				//elementor
				//add_action( 'init', array(&$this, 'iv_directories_elementor_file') );
				//add_action( 'elementor/elements/categories_registered', array(&$this, 'add_elementor_widget_categories' ));

				//---- COMMENT FILTERS ----//
				add_action('init', array($this, 'remove_admin_bar') );
				add_action( 'init', array($this, 'ep_post_type') );
				add_action( 'init', array($this, 'ep_create_my_taxonomy_category'));
				add_action( 'init', array($this, 'ep_create_my_taxonomy_tags'));
				add_filter( 'template_include', array($this, 'include_template_function'), 9, 2  );
			}
			/**
				* Define constants needed across the plug-in.
			*/
			private function define_constants() {
				if (!defined('wp_iv_directories_BASENAME')) define('wp_iv_directories_BASENAME', plugin_basename(__FILE__));
				if (!defined('wp_iv_directories_DIR')) define('wp_iv_directories_DIR', dirname(__FILE__));
				if (!defined('wp_iv_directories_FOLDER'))define('wp_iv_directories_FOLDER', plugin_basename(dirname(__FILE__)));
				if (!defined('wp_iv_directories_ABSPATH'))define('wp_iv_directories_ABSPATH', trailingslashit(str_replace("\\", "/", WP_PLUGIN_DIR . '/' . plugin_basename(dirname(__FILE__)))));
				if (!defined('wp_iv_directories_URLPATH'))define('wp_iv_directories_URLPATH', trailingslashit(WP_PLUGIN_URL . '/' . plugin_basename(dirname(__FILE__))));
				if (!defined('wp_iv_directories_ADMINPATH'))define('wp_iv_directories_ADMINPATH', get_admin_url());
				$filename = get_stylesheet_directory()."/hotellisting/";
				if (!file_exists($filename)) {
					if (!defined('wp_iv_directories_template'))define( 'wp_iv_directories_template', wp_iv_directories_ABSPATH.'template/' );
					}else{
					if (!defined('wp_iv_directories_template'))define( 'wp_iv_directories_template', $filename);
				}
			}


			// elementor files
			public function add_elementor_widget_categories() {

					\Elementor\Plugin::$instance->elements_manager->add_category(
						'hotel-listing',
						[
							'title' => __( 'Hotel Listing', 'ivdirectories' ),
							'icon'  => 'fa fa-plug',
						]
					);

				}

				public function iv_directories_elementor_file() {
						if ( in_array( 'elementor/elementor.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
							include(wp_iv_directories_template.'elementor/elementor-single-meta.php');
					}
		    }


			/**
				* Loads PHP files that required by the plug-in
			*/
			public function iv_directories_woocommerce_form_submit(  ) {
				include(wp_iv_directories_ABSPATH . '/admin/pages/payment-inc/woo-submit.php');
			}
			public function remove_admin_bar() {
				$iv_hide = get_option( '_iv_directories_hide_admin_bar');
				if (!current_user_can('administrator') && !is_admin()) {
					if($iv_hide=='yes'){
						show_admin_bar(false);
					}
				}
			}
			public function include_template_function( $template_path ) {
				$default_fields = array();
				$field_set=get_option('_iv_directory_url_postype' );
				if($field_set!=""){
					$default_fields=get_option('_iv_directory_url_postype' );
					}else{
					$default_fields['hotel']='Hotel';
					$default_fields['restaurant']='Restaurant';
					$default_fields['bar']='Bar';
				}
				foreach ( $default_fields as $field_key => $field_value ) {
					if ( get_post_type() == $field_key ) {
						if ( is_single() ) {
							$template_path =  wp_iv_directories_template. 'listing/single-listing.php';
						}
						if( is_tag() || is_category() || is_archive() ){
							$template_path =  wp_iv_directories_template. 'listing/listing-layout.php';
						}
					}
				}
				return $template_path;
			}
			public function ep_post_type(){
				$default_fields = array();
				$field_set=get_option('_iv_directory_url_postype' );
				if($field_set!=""){
					$default_fields=get_option('_iv_directory_url_postype' );
					}else{
					$default_fields['hotel']='Hotel';
					$default_fields['restaurant']='Restaurant';
					$default_fields['bar']='Bar';
				}
				foreach ( $default_fields as $field_key => $field_value ) {
					if($field_key!="" ){
						$labels = array(
						'name'                => _x( $field_value, 'Post Type General Name', 'ivdirectories' ),
						'singular_name'       => _x( $field_value, 'Post Type Singular Name', 'ivdirectories' ),
						'menu_name'           => esc_html__( $field_value, 'ivdirectories' ),
						'name_admin_bar'      => esc_html__( $field_value, 'ivdirectories' ),
						'parent_item_colon'   => esc_html__( 'Parent Item:', 'ivdirectories' ),
						'all_items'           => esc_html__( 'All Items', 'ivdirectories' ),
						'add_new_item'        => esc_html__( 'Add New Item', 'ivdirectories' ),
						'add_new'             => esc_html__( 'Add New', 'ivdirectories' ),
						'new_item'            => esc_html__( 'New Item', 'ivdirectories' ),
						'edit_item'           => esc_html__( 'Edit Item', 'ivdirectories' ),
						'update_item'         => esc_html__( 'Update Item', 'ivdirectories' ),
						'view_item'           => esc_html__( 'View Item', 'ivdirectories' ),
						'search_items'        => esc_html__( 'Search Item', 'ivdirectories' ),
						'not_found'           => esc_html__( 'Not found', 'ivdirectories' ),
						'not_found_in_trash'  => esc_html__( 'Not found in Trash', 'ivdirectories' ),
						);
						$args = array(
						'label'               => esc_html__( $field_value, 'ivdirectories' ),
						'description'         => esc_html__( $field_value, 'ivdirectories' ),
						'labels'              => $labels,
						'supports'            => array( 'title', 'editor', 'author', 'thumbnail', 'comments', 'post-formats','custom-fields' ),
						'hierarchical'        => false,
						'public'              => true,
						'show_ui'             => true,
						'show_in_menu'        => true,
						'menu_position'       => 5,
						'show_in_admin_bar'   => true,
						'show_in_nav_menus'   => true,
						'can_export'          => true,
						'has_archive'         => true,
						'exclude_from_search' => false,
						'publicly_queryable'  => true,
						'capability_type'     => 'post',
						);
						register_post_type( $field_key, $args );
					}
				}
			}
			public function ep_create_my_taxonomy_category(){
				$default_fields = array();
				$field_set=get_option('_iv_directory_url_postype' );
				if($field_set!=""){
					$default_fields=get_option('_iv_directory_url_postype' );
					}else{
					$default_fields['hotel']='Hotel';
					$default_fields['restaurant']='Restaurant';
					$default_fields['bar']='Bar';
				}
				foreach ( $default_fields as $field_key => $field_value ) {
					if($field_key!="" ){
						register_taxonomy(
						$field_key.'-category',
						$field_key,
						array(
						'label' => esc_html__( 'Categories', 'ivdirectories'),
						'rewrite' => array( 'slug' => $field_key.'-category' ),
						'hierarchical' => true,
						'query_var' => true,
						)
						);
					}
				}
			}
			public function ep_create_my_taxonomy_tags(){
				$default_fields = array();
				$field_set=get_option('_iv_directory_url_postype' );
				if($field_set!=""){
					$default_fields=get_option('_iv_directory_url_postype' );
					}else{
					$default_fields['hotel']='Hotel';
					$default_fields['restaurant']='Restaurant';
					$default_fields['bar']='Bar';
				}
				foreach ( $default_fields as $field_key => $field_value ) {
					if($field_key!="" ){
						register_taxonomy(
						$field_key.'_tag',
						$field_key,
						array(
						'label' => esc_html__( 'Tags', 'ivdirectories'),
						'rewrite' => array( 'slug' => $field_key.'_tag' ),
						'hierarchical' => true,
						'query_var' => true,
						)
						);
					}
				}
			}
			public function post_type_tags_fix($request) {
				if ( isset($request['tag']) && !isset($request['post_type']) ){
					$request['post_type'] = 'directories';
				}
				return $request;
			}
			public function dir_vc_pricing_table() {
				vc_map( array(
				"name" => esc_html__( "Pricing Table", "ivdirectories" ),
				"base" => "iv_directories_price_table",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Style Name", "ivdirectories" ),
				"param_name" => "no",
				"value" => esc_html__( "Default", "ivdirectories" ),
				"description" => esc_html__( "You can select the style from wp-admin e.g : style-1.", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_signup() {
				vc_map( array(
				"name" => esc_html__( "Signup ", "ivdirectories" ),
				"base" => "iv_directories_form_wizard",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Style Name", "ivdirectories" ),
				"param_name" => "Default",
				"value" => esc_html__( "Default", "ivdirectories" ),
				"description" => esc_html__( ".", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_my_account() {
				vc_map( array(
				"name" => esc_html__( "My Acount ", "ivdirectories" ),
				"base" => "iv_directories_profile_template",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Style Name", "ivdirectories" ),
				"param_name" => "Default",
				"value" => esc_html__( "Default", "ivdirectories" ),
				"description" => esc_html__( ".", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_public_profile() {
				vc_map( array(
				"name" => esc_html__( "Public Profile ", "ivdirectories" ),
				"base" => "iv_directories_profile_public",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Style Name", "ivdirectories" ),
				"param_name" => "Default",
				"value" => esc_html__( "Default", "ivdirectories" ),
				"description" => esc_html__( "You can select the style from wp-admin e.g : style-1 , style-2 ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_user_directory() {
				vc_map( array(
				"name" => esc_html__( "User Directory ", "ivdirectories" ),
				"base" => "iv_directories_user_directory",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Show  number of user / Page", "ivdirectories" ),
				"param_name" => "per_page",
				"value" => esc_html__( "12", "ivdirectories" ),
				"description" => esc_html__( "You can set the number : 10,20 ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_user_login() {
				vc_map( array(
				"name" => esc_html__( "Login", "ivdirectories" ),
				"base" => "iv_directories_login",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( " Login", "ivdirectories" ),
				"param_name" => "style",
				"value" => esc_html__( "Default", "ivdirectories" ),
				"description" => esc_html__( "Default ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_listing_slider(){
				vc_map( array(
				"name" => esc_html__( "Listing Slider", "ivdirectories" ),
				"base" => "iv_listing_slider",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( " Title", "ivdirectories" ),
				"param_name" => "style",
				"value" => esc_html__( "Listing Slider", "ivdirectories" ),
				"description" => esc_html__( "Default ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_listing_feature_image(){
				vc_map( array(
				"name" => esc_html__( "Listing feature image", "ivdirectories" ),
				"base" => "iv_listing_feature_image",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( " Title", "ivdirectories" ),
				"param_name" => "style",
				"value" => esc_html__( "Listing feature image", "ivdirectories" ),
				"description" => esc_html__( "Default ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_listing_contact_info(){
				vc_map( array(
				"name" => esc_html__( "Listing contact info", "ivdirectories" ),
				"base" => "iv_listing_contact_info",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( " Title", "ivdirectories" ),
				"param_name" => "style",
				"value" => esc_html__( "Listing contact info", "ivdirectories" ),
				"description" => esc_html__( "Default ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_listing_social_profile(){
				vc_map( array(
				"name" => esc_html__( "Listing social profile", "ivdirectories" ),
				"base" => "iv_listing_social_profile",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( " Title", "ivdirectories" ),
				"param_name" => "style",
				"value" => esc_html__( "Listing social profile", "ivdirectories" ),
				"description" => esc_html__( "Default ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_listing_about_us(){
				vc_map( array(
				"name" => esc_html__( "Listing about us", "ivdirectories" ),
				"base" => "iv_listing_about_us",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( " Title", "ivdirectories" ),
				"param_name" => "style",
				"value" => esc_html__( "Listing about us", "ivdirectories" ),
				"description" => esc_html__( "Default ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_listing_Specialitiess(){
				vc_map( array(
				"name" => esc_html__( "Listing Specialitiess", "ivdirectories" ),
				"base" => "iv_listing_Specialitiess",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( " Title", "ivdirectories" ),
				"param_name" => "style",
				"value" => esc_html__( "Listing Specialitiess", "ivdirectories" ),
				"description" => esc_html__( "Default ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_listing_awards(){
				vc_map( array(
				"name" => esc_html__( "Listing awards", "ivdirectories" ),
				"base" => "iv_listing_awards",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( " Title", "ivdirectories" ),
				"param_name" => "style",
				"value" => esc_html__( "Listing awards", "ivdirectories" ),
				"description" => esc_html__( "Default ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_listing_video(){
				vc_map( array(
				"name" => esc_html__( "Listing video", "ivdirectories" ),
				"base" => "iv_listing_video",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( " Title", "ivdirectories" ),
				"param_name" => "style",
				"value" => esc_html__( "Listing video", "ivdirectories" ),
				"description" => esc_html__( "Default ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_listing_event(){
				vc_map( array(
				"name" => esc_html__( "Listing event", "ivdirectories" ),
				"base" => "iv_listing_event",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( " Title", "ivdirectories" ),
				"param_name" => "style",
				"value" => esc_html__( "Listing event", "ivdirectories" ),
				"description" => esc_html__( "Default ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_listing_reviews(){
				vc_map( array(
				"name" => esc_html__( "Listing reviews", "ivdirectories" ),
				"base" => "iv_listing_reviews",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( " Title", "ivdirectories" ),
				"param_name" => "style",
				"value" => esc_html__( "Listing reviews", "ivdirectories" ),
				"description" => esc_html__( "Default ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_listing_working_time(){
				vc_map( array(
				"name" => esc_html__( "Listing working time", "ivdirectories" ),
				"base" => "iv_listing_working_time",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( " Title", "ivdirectories" ),
				"param_name" => "style",
				"value" => esc_html__( "Listing working time", "ivdirectories" ),
				"description" => esc_html__( "Default ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_listing_contact_us(){
				vc_map( array(
				"name" => esc_html__( "Listing contact us", "ivdirectories" ),
				"base" => "iv_listing_contact_us",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( " Title", "ivdirectories" ),
				"param_name" => "style",
				"value" => esc_html__( "Listing contact us", "ivdirectories" ),
				"description" => esc_html__( "Default ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_listing_claim(){
				vc_map( array(
				"name" => esc_html__( "Listing claim", "ivdirectories" ),
				"base" => "iv_listing_claim",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( " Title", "ivdirectories" ),
				"param_name" => "style",
				"value" => esc_html__( "Listing claim", "ivdirectories" ),
				"description" => esc_html__( "Default ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_listing_share_it(){
				vc_map( array(
				"name" => esc_html__( "Listing share it", "ivdirectories" ),
				"base" => "iv_listing_share_it",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( " Title", "ivdirectories" ),
				"param_name" => "style",
				"value" => esc_html__( "Listing share it", "ivdirectories" ),
				"description" => esc_html__( "Default ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_listing_map(){
				vc_map( array(
				"name" => esc_html__( "Listing map", "ivdirectories" ),
				"base" => "iv_listing_map",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( " Title", "ivdirectories" ),
				"param_name" => "style",
				"value" => esc_html__( "Listing map", "ivdirectories" ),
				"description" => esc_html__( "Default ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_listing_logo(){
				vc_map( array(
				"name" => esc_html__( "Listing Logo", "ivdirectories" ),
				"base" => "iv_listing_logo",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( " Title", "ivdirectories" ),
				"param_name" => "style",
				"value" => esc_html__( "Listing Logo", "ivdirectories" ),
				"description" => esc_html__( "Default ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_listing_comments(){
				vc_map( array(
				"name" => esc_html__( "Listing Comments", "ivdirectories" ),
				"base" => "iv_listing_comments",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( " Title", "ivdirectories" ),
				"param_name" => "style",
				"value" => esc_html__( "Listing Comments", "ivdirectories" ),
				"description" => esc_html__( "Default ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_listing_tag(){
				vc_map( array(
				"name" => esc_html__( "Listing Tags", "ivdirectories" ),
				"base" => "iv_listing_tag",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( " Title", "ivdirectories" ),
				"param_name" => "style",
				"value" => esc_html__( "Listing Tags", "ivdirectories" ),
				"description" => esc_html__( "Default ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_listing_doc(){
				vc_map( array(
				"name" => esc_html__( "Listing Documents", "ivdirectories" ),
				"base" => "iv_listing_doc",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( " Title", "ivdirectories" ),
				"param_name" => "style",
				"value" => esc_html__( "Listing Documents", "ivdirectories" ),
				"description" => esc_html__( "Default ", "ivdirectories" )
				)
				)
				) );
			}
			public function dir_vc_listing_about_us_fields(){
				vc_map( array(
				"name" => esc_html__( "Listing about us fields", "ivdirectories" ),
				"base" => "iv_listing_about_us_fields",
				'icon' =>  wp_iv_directories_URLPATH.'/assets/images/vc-icon.png',
				"class" => "",
				"category" => esc_html__( "Content", "ivdirectories"),
				"params" => array(
				array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( " Title", "ivdirectories" ),
				"param_name" => "style",
				"value" => esc_html__( "Listing about us fields", "ivdirectories" ),
				"description" => esc_html__( "Default ", "ivdirectories" )
				)
				)
				) );
			}
			public function author_public_profile() {
				$author = get_the_author();
				$iv_redirect = get_option( '_iv_directories_profile_public_page');
				if($iv_redirect!='defult'){
					$reg_page= get_permalink( $iv_redirect) ;
					return    $reg_page.'?&id='.$author;
					exit;
				}
			}
			public function iv_registration_redirect(){
				$iv_redirect = get_option( 'iv_directories_signup_redirect');
				if($iv_redirect!='defult'){
					$reg_page= get_permalink( $iv_redirect);
					wp_redirect( $reg_page );
					exit;
				}
			}
			public function listing_slider_func(){
				include(wp_iv_directories_template. 'listing/visual-composer/slider_shortcode.php');
			}
			public function listing_feature_image_func(){
				include(wp_iv_directories_template. 'listing/visual-composer/feature_image_shortcode.php');
			}
			public function listing_contact_info_func(){
				include(wp_iv_directories_template. 'listing/visual-composer/contact_info_shortcode.php');
			}
			public function listing_social_profile_func(){
				include(wp_iv_directories_template. 'listing/visual-composer/social_profile_shortcode.php');
			}
			public function listing_about_us_func(){
				include(wp_iv_directories_template. 'listing/visual-composer/about_us_shortcode.php');
			}
			public function listing_about_us_fields_func(){
				include(wp_iv_directories_template. 'listing/visual-composer/about_us_fields_shortcode.php');
			}
			public function listing_Specialitiess_func(){
				include(wp_iv_directories_template. 'listing/visual-composer/specialties_shortcode.php');
			}
			public function listing_awards_func(){
				include(wp_iv_directories_template. 'listing/visual-composer/awards_shortcode.php');
			}
			public function listing_video_func(){
				include(wp_iv_directories_template. 'listing/visual-composer/video_shortcode.php');
			}
			public function listing_event_func(){
				include(wp_iv_directories_template. 'listing/visual-composer/event_shortcode.php');
			}
			public function listing_reviews_func(){
				include(wp_iv_directories_template. 'listing/visual-composer/reviews_shortcode.php');
			}
			public function listing_working_time_func(){
				include(wp_iv_directories_template. 'listing/visual-composer/working_time_shortcode.php');
			}
			public function listing_contact_us_func(){
				include(wp_iv_directories_template. 'listing/visual-composer/contact_us_shortcode.php');
			}
			public function listing_claim_func(){
				include(wp_iv_directories_template. 'listing/visual-composer/claim_shortcode.php');
			}
			public function listing_share_it_func(){
				include(wp_iv_directories_template. 'listing/visual-composer/share_it_shortcode.php');
			}
			public function listing_map_func(){
				include(wp_iv_directories_template. 'listing/visual-composer/map_shortcode.php');
			}
			public function listing_logo_func(){
				include(wp_iv_directories_template. 'listing/visual-composer/logo_shortcode.php');
			}
			public function listing_comments_func(){
				include(wp_iv_directories_template. 'listing/visual-composer/comments_shortcode.php');
			}
			public function listing_tag_func(){
				include(wp_iv_directories_template. 'listing/visual-composer/tag_shortcode.php');
			}
			public function listing_doc_func(){
				include(wp_iv_directories_template. 'listing/visual-composer/doc_shortcode.php');
			}
			public function iv_directories_login_func(){
				ob_start();
				global $current_user;
				if($current_user->ID==0){
					include(wp_iv_directories_template. 'private-profile/profile-login.php');
					}else{
					include( wp_iv_directories_template. 'private-profile/profile-template-1.php');
				}
				$content = ob_get_clean();
				return $content;
			}
			public function iv_directories_forget_password(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'myaccount' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				parse_str($_POST['form_data'], $data_a);
				if( ! email_exists($data_a['forget_email']) ) {
					echo json_encode(array("code" => "not-success","msg"=> esc_html__( 'There is no user registered with that email address.', 'ivdirectories' )));
					exit(0);
					} else {
					include( wp_iv_directories_ABSPATH. 'inc/forget-mail.php');
					echo json_encode(array("code" => "success","msg"=>esc_html__( 'Update Successfully', 'ivdirectories' )));
					exit(0);
				}
			}
			public function hd_search_box_func($atts = ''){
				ob_start();
				include( wp_iv_directories_template. 'listing/slider-search.php');
				$content = ob_get_clean();
				return $content;
			}
			public function iv_directories_check_login(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'myaccount' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				parse_str($_POST['form_data'], $form_data);
				global $user;
				$creds = array();
				$creds['user_login'] = $form_data['username'];
				$creds['user_password'] =  sanitize_text_field($form_data['password']);
				$creds['remember'] =  (isset($form_data['remember']) ?'true' : 'false');
				$secure_cookie = is_ssl() ? true : false;
				$user = wp_signon( $creds, $secure_cookie );
				if ( is_wp_error($user) ) {
					echo json_encode(array("code" => "not-success","msg"=>$user->get_error_message()));
					exit(0);
				}
				if ( !is_wp_error($user) ) {
					$iv_redirect = get_option( '_iv_directories_profile_page');
					if($iv_redirect!='defult'){
						if ( function_exists('icl_object_id') ) {
							$iv_redirect = icl_object_id($iv_redirect, 'page', true);
						}
						$reg_page= get_permalink( $iv_redirect);
						echo json_encode(array("code" => "success","msg"=>$reg_page));
						exit(0);
					}
				}
			}
			// Rating********
			public function iv_directories_save_rating(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'contact' ) ) {
					echo json_encode(array("msg"=>"Are you cheating:wpnonce?"));
					exit(0);
				}
				parse_str($_POST['data'], $form_data);
				$profile_user_id=sanitize_text_field($form_data['id']);
				$rating_text=sanitize_text_field($form_data['rating_text']);
				$rating_value=sanitize_text_field($form_data['rating_value']);
				$total_count=get_post_meta($profile_user_id,'_rating_total_count',true);
				$old_rating= get_user_meta(get_current_user_id(),$rating_text.'_rating'.'|'.$profile_user_id,true);
				if($old_rating<1){
					$total_count=(int)$total_count+1;
				}
				$total_rating=get_post_meta($profile_user_id,$rating_text.'_rating',true);
				$count_the_rating=get_post_meta($profile_user_id,$rating_text.'_count',true);
				if($old_rating>0){
					$count_the_rating=(int)$count_the_rating-1;
				}
				$count_the_rating=(int)$count_the_rating + 1 ;
				$total_rating=(int)$total_rating-(int)$old_rating;
				$total_rating=(int)$total_rating+(int)$rating_value;
				update_post_meta($profile_user_id,$rating_text.'_count',$count_the_rating);
				update_post_meta($profile_user_id,$rating_text.'_rating',$total_rating);
				update_post_meta($profile_user_id,'_rating_total_count',$total_count);
				update_user_meta(get_current_user_id(),$rating_text.'_rating'.'|'.$profile_user_id,$rating_value);
				echo json_encode(array("msg" => 'success'));
				exit(0);
			}
			public function finalerp_csv_product_upload(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'csv' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				$csv_file_id=0;$maping='';
				if(isset($_POST['csv_file_id'])){
					$csv_file_id= sanitize_text_field($_POST['csv_file_id']);
				}
				require(wp_iv_directories_DIR .'/admin/pages/importer/upload_main_big_csv.php');
				$total_files = get_option( 'finalerp-number-of-files');
				echo json_encode(array("code" => "success","msg"=>esc_html__( 'Updated Successfully', 'ivdirectories'), "maping"=>$maping));
				exit(0);
			}
			public function save_csv_file_to_database(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'csv' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				parse_str($_POST['form_data'], $form_data);
				$csv_file_id=0;
				if(isset($_POST['csv_file_id'])){
					$csv_file_id= sanitize_text_field($_POST['csv_file_id']);
				}
				$row_start=0;
				if(isset($_POST['row_start'])){
					$row_start= sanitize_text_field($_POST['row_start']);
				}
				require (wp_iv_property_DIR .'/admin/pages/importer/csv_save_database.php');
				echo json_encode(array("code" => $done_status,"msg"=>esc_html__( 'Updated Successfully', 'ivdirectories'), "row_done"=>$row_done ));
				exit(0);
			}
			public function eppro_get_import_status(){
				$eppro_total_row = floatval( get_option( 'eppro_total_row' ));
				$eppro_current_row = floatval( get_option( 'eppro_current_row' ));
				$progress =  ((int)$eppro_current_row / (int)$eppro_total_row)*100;
				if($eppro_total_row<=$eppro_current_row){$progress='100';}
				if($progress=='100'){
					echo json_encode(array("code" => "-1","progress"=>(int)$progress, "eppro_total_row"=>$eppro_total_row,"eppro_current_row"=>$eppro_current_row));
					}else{
					echo json_encode(array("code" => "0","progress"=>(int)$progress, "eppro_total_row"=>$eppro_total_row ,"eppro_current_row"=>$eppro_current_row));
				}
				exit(0);
			}
			public function iv_directories_update_listing(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'myaccount' ) ) {
					echo json_encode(array("msg"=>"Are you cheating:wpnonce?"));
					exit(0);
				}
				global $current_user;global $wpdb;
				parse_str($_POST['form_data'], $form_data);
				if($form_data['post_status']=='publish'){
					$form_data['post_status']='pending';
					if(isset($current_user->roles[0]) and $current_user->roles[0]=='administrator'){
						$form_data['post_status']='publish';
						}else{
						$form_data['post_status']='pending';
					}
				}
				$allowed_html = wp_kses_allowed_html( 'post' );
				$post_content= wp_kses( $form_data['edit_post_content'], $allowed_html);
				$newpost_id=sanitize_text_field($form_data['user_post_id']);
				$query = $wpdb->prepare("UPDATE {$wpdb->prefix}posts SET post_title='%s', post_content='%s', post_status='%s'   WHERE id='%s' LIMIT 1",sanitize_text_field($form_data['title']),$post_content,$form_data['post_status'], sanitize_text_field($form_data['user_post_id']));
				$wpdb->query($query);
				$post_type = sanitize_text_field($form_data['cpt_page']);
				if($post_type!=''){
					$query = $wpdb->prepare("UPDATE {$wpdb->prefix}posts SET post_type='%s' WHERE id='%s' LIMIT 1",$post_type, $newpost_id );
					$wpdb->query($query);
				}
				if(isset($form_data['feature_image_id'] )){
					$attach_id =$form_data['feature_image_id'];
					set_post_thumbnail( $newpost_id, $attach_id );
				}
				if(isset($form_data['postcats'] )){
					$category_ids = array($form_data['postcats']);
					$post_cats= array();
					foreach($category_ids AS $cid) {
						$post_cats=$cid;
					}
					wp_set_object_terms( $newpost_id, $post_cats, $post_type.'-category');
				}
				$default_fields = array();
				$field_set=get_option('iv_directories_fields' );
				if($field_set!="" ){
					$default_fields=get_option('iv_directories_fields' );
					}else{
					$default_fields['Rooms']='Rooms';
					$default_fields['suites']='Suites';
					$default_fields['Rating_stars']='Rating Stars';
					$default_fields['CHECK_IN']='Check In';
					$default_fields['CHECK_out']='Check Out';
					$default_fields['Cancellation']='Cancellation';
					$default_fields['Pets']='Pets';
					$default_fields['Children_and_Extra_Beds']='Children and Extra Beds';
				}
				if(is_array($default_fields )){
					foreach( $default_fields as $field_key => $field_value ) {
						if(isset($form_data[$field_key])){
							$form_data[$field_key];
							update_post_meta($newpost_id, sanitize_text_field($field_key), sanitize_text_field($form_data[$field_key]) );
						}
					}
				}
				$opening_day=array();
				if(isset($form_data['day_name'] )){
					$day_name= $form_data['day_name'] ;
					$day_value1 = $form_data['day_value1'] ;
					$day_value2 = $form_data['day_value2'] ;
					$i=0;
					foreach($day_name  as $one_meta){
						if(isset($day_name[$i]) and isset($day_value1[$i]) ){
							if($day_name[$i] !=''){
								$opening_day[sanitize_text_field($day_name[$i])]=sanitize_text_field($day_value1[$i]).'|'.sanitize_text_field($day_value2[$i]);
							}
						}
						$i++;
					}
					update_post_meta($newpost_id, '_opening_time', $opening_day);
				}
				// For Tag Save tag_arr
				$tag_all='';
				if(isset($form_data['tag_arr'] )){
					$tag_name= $form_data['tag_arr'] ;
					$i=0;$tag_all='';
					wp_set_object_terms( $newpost_id, $tag_name, $post_type.'_tag');
				}
				$tag_all='';
				if(isset($form_data['new_tag'] )){
					$tag_new= explode(",", $form_data['new_tag']);
					foreach($tag_new  as $one_tag){
						wp_add_object_terms( $newpost_id, sanitize_text_field($one_tag), $post_type.'_tag');
						$i++;
					}
				}
				// For Specialities Save
				$Specialities_all='';
				if(isset($form_data['Specialities_arr'] )){
					$Specialities_name= $form_data['Specialities_arr'] ;
					$i=0;$Specialities_all='';
					foreach($Specialities_name  as $one_Specialities){
						$Specialities_all= $Specialities_all.",".sanitize_text_field($one_Specialities);
					}
					update_post_meta($newpost_id, 'Specialities', $Specialities_all);
				}
				// For Awards Save
				// Delete 1st
				$i=0;
				for($i=0;$i<20;$i++){
					delete_post_meta($newpost_id, '_award_title_'.$i);
					delete_post_meta($newpost_id, '_award_description_'.$i);
					delete_post_meta($newpost_id, '_award_year_'.$i);
					delete_post_meta($newpost_id, '_award_image_id_'.$i);
				}
				// Delete End
				if(isset($form_data['award_title'] )){
					$award_title= $form_data['award_title'];
					$award_description= $form_data['award_description'];
					$award_year= $form_data['award_year'];
					$award_image_id= (isset($form_data['award_image_id']) ? $form_data['award_image_id']:'');
					$i=0;
					for($i=0;$i<20;$i++){
						if(isset($award_title[$i])){
							update_post_meta($newpost_id, '_award_title_'.$i, sanitize_text_field($award_title[$i]));
						}
						if(isset($award_description[$i])){
							update_post_meta($newpost_id, '_award_description_'.$i, sanitize_textarea_field($award_description[$i]));
						}
						if(isset($award_year[$i])){
							update_post_meta($newpost_id, '_award_year_'.$i, sanitize_text_field($award_year[$i]));
						}
						if(isset($award_image_id[$i])){
							update_post_meta($newpost_id, '_award_image_id_'.$i, $award_image_id[$i]);
						}
					}
				}
				// For Menu Save
				// Delete 1st
				$i=0;
				for($i=0;$i<50;$i++){
					delete_post_meta($newpost_id, '_menu_title_'.$i);
					delete_post_meta($newpost_id, '_menu_description_'.$i);
					delete_post_meta($newpost_id, '_menu_price_'.$i);
					delete_post_meta($newpost_id, '_menu_order_'.$i);
					delete_post_meta($newpost_id, '_menu_image_id_'.$i);
				}
				// Delete End
				if(isset($form_data['menu_title'] )){
					$menu_title= $form_data['menu_title'];
					$menu_description= $form_data['menu_description'];
					$menu_price= $form_data['menu_price'];
					$menu_image_id= (isset($form_data['menu_image_id']) ? $form_data['menu_image_id']:'');
					$menu_order	=$form_data['menu_order'];
					$i=0;
					for($i=0;$i<50;$i++){
						if(isset($menu_title[$i])){
							update_post_meta($newpost_id, '_menu_title_'.$i, sanitize_text_field($menu_title[$i]));
						}
						if(isset($menu_description[$i])){
							update_post_meta($newpost_id, '_menu_description_'.$i, sanitize_text_field($menu_description[$i]));
						}
						if(isset($menu_price[$i])){
							update_post_meta($newpost_id, '_menu_price_'.$i, sanitize_text_field($menu_price[$i]));
						}
						if(isset($menu_order[$i])){
							update_post_meta($newpost_id, '_menu_order_'.$i, sanitize_text_field($menu_order[$i]));
						}
						if(isset($menu_image_id[$i])){
							update_post_meta($newpost_id, '_menu_image_id_'.$i, $menu_image_id[$i]);
						}
						//$i++;
					}
				}
				// For room Save
				// Delete 1st
				$i=0;
				for($i=0;$i<50;$i++){
					delete_post_meta($newpost_id, '_room_title_'.$i);
					delete_post_meta($newpost_id, '_room_description_'.$i);
					delete_post_meta($newpost_id, '_room_price_'.$i);
					delete_post_meta($newpost_id, '_room_order_'.$i);
					delete_post_meta($newpost_id, '_room_image_id_'.$i);
				}
				// Delete End
				if(isset($form_data['room_title'] )){
					$room_title= $form_data['room_title'];
					$room_description= $form_data['room_description'];
					$room_price= $form_data['room_price'];
					$room_image_id= (isset($form_data['room_image_id']) ? $form_data['room_image_id']:'');
					$room_order	=$form_data['room_order'];
					$i=0;
					for($i=0;$i<50;$i++){
						if(isset($room_title[$i])){
							update_post_meta($newpost_id, '_room_title_'.$i, sanitize_text_field($room_title[$i]));
						}
						if(isset($room_description[$i])){
							update_post_meta($newpost_id, '_room_description_'.$i, sanitize_text_field($room_description[$i]));
						}
						if(isset($room_price[$i])){
							update_post_meta($newpost_id, '_room_price_'.$i, sanitize_text_field($room_price[$i]));
						}
						if(isset($room_order[$i])){
							update_post_meta($newpost_id, '_room_order_'.$i, sanitize_text_field($room_order[$i]));
						}
						if(isset($room_image_id[$i])){
							update_post_meta($newpost_id, '_room_image_id_'.$i, $room_image_id[$i]);
						}
					}
				}
				// Booking From
				update_post_meta($newpost_id, '_booking_type', sanitize_text_field($form_data['override_bookingf']));
				update_post_meta($newpost_id, '_booking_stcode', sanitize_text_field($form_data['booking_stcode']));

				update_post_meta($newpost_id, 'address', sanitize_text_field($form_data['address']));
				update_post_meta($newpost_id, 'latitude', sanitize_text_field($form_data['latitude']));
				update_post_meta($newpost_id, 'longitude', sanitize_text_field($form_data['longitude']));
				update_post_meta($newpost_id, 'area', sanitize_text_field($form_data['area']));
				update_post_meta($newpost_id, 'city', sanitize_text_field($form_data['city']));
				update_post_meta($newpost_id, 'state', sanitize_text_field($form_data['state']));
				update_post_meta($newpost_id, 'postcode', sanitize_text_field($form_data['postcode']));
				update_post_meta($newpost_id, 'country', sanitize_text_field($form_data['country']));
				// Get latlng from address* START********
				$dir_lat=sanitize_text_field($form_data['latitude']);
				$dir_lng=sanitize_text_field($form_data['longitude']);
				// Get latlng from address* END********
				update_post_meta($newpost_id, 'logo_image_id', $form_data['logo_image_id']);
				update_post_meta($newpost_id, 'image_gallery_ids', $form_data['gallery_image_ids']);
				update_post_meta($newpost_id, 'phone', sanitize_text_field($form_data['phone']));
				update_post_meta($newpost_id, 'fax', sanitize_text_field($form_data['fax']));
				update_post_meta($newpost_id, 'contact-email', sanitize_email($form_data['contact-email']));
				update_post_meta($newpost_id, 'contact_web', esc_url_raw($form_data['contact_web']));
				if(isset($form_data['vimeo'] )){
					update_post_meta($newpost_id, 'vimeo', sanitize_text_field($form_data['vimeo']));
					update_post_meta($newpost_id, 'youtube', sanitize_text_field($form_data['youtube']));
				}
				update_post_meta($newpost_id, 'facebook', sanitize_text_field($form_data['facebook']));
				update_post_meta($newpost_id, 'linkedin',sanitize_text_field( $form_data['linkedin']));
				update_post_meta($newpost_id, 'twitter',sanitize_text_field( $form_data['twitter']));
				update_post_meta($newpost_id, 'pinterest', sanitize_text_field($form_data['pinterest']));
				update_post_meta($newpost_id, 'instagram', sanitize_text_field($form_data['instagram']));
				if(isset($form_data['event-title'])){
					update_post_meta($newpost_id, '_event_image_id', $form_data['event_image_id']);
					update_post_meta($newpost_id, 'event_title', sanitize_text_field($form_data['event-title']));
					update_post_meta($newpost_id, 'event_detail', sanitize_text_field($form_data['event-detail']));
				}
				delete_post_meta($newpost_id, 'eplisting-category');
				delete_post_meta($newpost_id, 'eplisting-tag');
				echo json_encode(array("code" => "success","msg"=>esc_html__( 'Update Successfully', 'ivdirectories' )));
				exit(0);
			}
			public function eplisting_get_categories_caching($id, $post_type){				
				if(metadata_exists('post', $id, 'eplisting-category')) {
					$items = get_post_meta($id,'eplisting-category',true );										
					}else{									
					$items=wp_get_object_terms( $id, $post_type.'-category');
					update_post_meta($id, 'eplisting-category' , $items);
					
				}					
				return $items;
			}
			public function eplisting_get_tag_caching($id, $post_type){				
				if(metadata_exists('post', $id, 'eplisting-tag')) {
					$items = get_post_meta($id,'eplisting-tag',true );										
					}else{									
					$items=wp_get_object_terms( $id, $post_type.'_tag');
					update_post_meta($id, 'eplisting-tag' , $items);
				}					
				return $items;
			}
			public function iv_directories_save_listing(){
				global $current_user; global $wpdb;
				parse_str($_POST['form_data'], $form_data);
				$allowed_html = wp_kses_allowed_html( 'post' );
				$my_post = array();
				$my_post['post_title'] = sanitize_text_field($form_data['title']);
				$my_post['post_content'] = wp_kses( $form_data['new_post_content'], $allowed_html);
				if($form_data['post_status']=='publish'){
					$form_data['post_status']='pending';
					if(isset($current_user->roles[0]) and $current_user->roles[0]=='administrator'){
						$form_data['post_status']='publish';
						}else{
						$form_data['post_status']='pending';
					}
				}
				$my_post['post_status'] = sanitize_text_field($form_data['post_status']);
				$newpost_id= wp_insert_post( $my_post );
				$post_type = sanitize_text_field($form_data['cpt_page']);
				if($post_type!=''){
					$query = $wpdb->prepare("UPDATE {$wpdb->prefix}posts SET post_type='%s' WHERE id='%s' LIMIT 1",$post_type,$newpost_id  );
					$wpdb->query($query);
				}
				// WPML Start******
				if ( function_exists('icl_object_id') ) {
					include_once( WP_PLUGIN_DIR . '/sitepress-multilingual-cms/inc/wpml-api.php' );
					$_POST['icl_post_language'] = $language_code = ICL_LANGUAGE_CODE;
					$query = "UPDATE {$wpdb->prefix}icl_translations SET element_type='post_".$post_type."' WHERE element_id='" . $newpost_id . "' LIMIT 1";
					$wpdb->query($query);
				}
				// End WPML**********
				if(isset($form_data['feature_image_id'] )){
					$attach_id =$form_data['feature_image_id'];
					set_post_thumbnail( $newpost_id, $attach_id );
				}
				if(isset($form_data['postcats'] )){
					$category_ids = array($form_data['postcats']);
					$post_cats= array();
					foreach($category_ids AS $cid) {
						$post_cats=$cid;
					}
					wp_set_object_terms( $newpost_id, $post_cats, $post_type.'-category');
				}
				$default_fields = array();
				$field_set=get_option('iv_directories_fields' );
				if($field_set!=""){
					$default_fields=get_option('iv_directories_fields' );
					}else{
					$default_fields['Rooms']='Rooms';
					$default_fields['suites']='Suites';
					$default_fields['Rating_stars']='Rating Stars';
					$default_fields['CHECK_IN']='Check In';
					$default_fields['CHECK_out']='Check Out';
					$default_fields['Cancellation']='Cancellation';
					$default_fields['Pets']='Pets';
					$default_fields['Children_and_Extra_Beds']='Children and Extra Beds';
				}
				if(is_array($default_fields )){
					foreach( $default_fields as $field_key => $field_value ) {
						if(isset($form_data[$field_key])){
							update_post_meta($newpost_id, sanitize_text_field($field_key), sanitize_text_field($form_data[$field_key]) );
						}
					}
				}
				$opening_day=array();
				if(isset($form_data['day_name'] )){
					$day_name= $form_data['day_name'] ;
					$day_value1 = $form_data['day_value1'] ;
					$day_value2 = $form_data['day_value2'] ;
					$i=0;
					foreach($day_name  as $one_meta){
						if(isset($day_name[$i]) and isset($day_value1[$i]) ){
							if($day_name[$i] !=''){
								$opening_day[sanitize_text_field($day_name[$i])]=sanitize_text_field($day_value1[$i]).'|'.sanitize_text_field($day_value2[$i]);
							}
						}
						$i++;
					}
					update_post_meta($newpost_id, '_opening_time', $opening_day);
				}
				// For Specialities Save
				$Specialities_all='';
				if(isset($form_data['Specialities_arr'] )){
					$Specialities_name= $form_data['Specialities_arr'] ;
					$i=0;$Specialities_all='';
					foreach($Specialities_name  as $one_Specialities){
						$Specialities_all= $Specialities_all.",".sanitize_text_field($one_Specialities);
					}
					update_post_meta($newpost_id, 'Specialities', $Specialities_all);
				}

				// For Awards Save
				if(isset($form_data['award_title'] )){
					$award_title= $form_data['award_title'];
					$award_description= $form_data['award_description'];
					$award_year= $form_data['award_year'];
					$award_image_id= (isset($form_data['award_image_id']) ? $form_data['award_image_id']:'');
					$i=0;
					for($i=0;$i<20;$i++){
						if(isset($award_title[$i])){
							update_post_meta($newpost_id, '_award_title_'.$i, sanitize_text_field($award_title[$i]));
						}
						if(isset($award_description[$i])){
							update_post_meta($newpost_id, '_award_description_'.$i, sanitize_text_field($award_description[$i]));
						}
						if(isset($award_year[$i])){
							update_post_meta($newpost_id, '_award_year_'.$i, sanitize_text_field($award_year[$i]));
						}
						if(isset($award_image_id[$i])){
							update_post_meta($newpost_id, '_award_image_id_'.$i, $award_image_id[$i]);
						}
					}
				}
				// For Tag Save tag_arr
				$tag_all='';
				if(isset($form_data['tag_arr'] )){
					$tag_name= $form_data['tag_arr'] ;
					$i=0;$tag_all='';
					wp_set_object_terms( $newpost_id, $tag_name, $post_type.'_tag');
				}
				$tag_all='';
				if(isset($form_data['new_tag'] )){
					$tag_new= explode(",", $form_data['new_tag']);
					foreach($tag_new  as $one_tag){
						wp_add_object_terms( $newpost_id, sanitize_text_field($one_tag), $post_type.'_tag');
						$i++;
					}
				}

					// For Menu Save


				if(isset($form_data['menu_title'] )){
					$menu_title= $form_data['menu_title'];
					$menu_description= $form_data['menu_description'];
					$menu_price= $form_data['menu_price'];
					$menu_image_id= (isset($form_data['menu_image_id']) ? $form_data['menu_image_id']:'');
					$menu_order	=$form_data['menu_order'];
					$i=0;
					for($i=0;$i<50;$i++){
						if(isset($menu_title[$i])){
							update_post_meta($newpost_id, '_menu_title_'.$i, sanitize_text_field($menu_title[$i]));
						}
						if(isset($menu_description[$i])){
							update_post_meta($newpost_id, '_menu_description_'.$i, sanitize_text_field($menu_description[$i]));
						}
						if(isset($menu_price[$i])){
							update_post_meta($newpost_id, '_menu_price_'.$i, sanitize_text_field($menu_price[$i]));
						}
						if(isset($menu_order[$i])){
							update_post_meta($newpost_id, '_menu_order_'.$i, sanitize_text_field($menu_order[$i]));
						}
						if(isset($menu_image_id[$i])){
							update_post_meta($newpost_id, '_menu_image_id_'.$i, $menu_image_id[$i]);
						}
						//$i++;
					}
				}
				// For room Save

				if(isset($form_data['room_title'] )){
					$room_title= $form_data['room_title'];
					$room_description= $form_data['room_description'];
					$room_price= $form_data['room_price'];
					$room_image_id= (isset($form_data['room_image_id']) ? $form_data['room_image_id']:'');
					$room_order	=$form_data['room_order'];
					$i=0;
					for($i=0;$i<50;$i++){
						if(isset($room_title[$i])){
							update_post_meta($newpost_id, '_room_title_'.$i, sanitize_text_field($room_title[$i]));
						}
						if(isset($room_description[$i])){
							update_post_meta($newpost_id, '_room_description_'.$i, sanitize_text_field($room_description[$i]));
						}
						if(isset($room_price[$i])){
							update_post_meta($newpost_id, '_room_price_'.$i, sanitize_text_field($room_price[$i]));
						}
						if(isset($room_order[$i])){
							update_post_meta($newpost_id, '_room_order_'.$i, sanitize_text_field($room_order[$i]));
						}
						if(isset($room_image_id[$i])){
							update_post_meta($newpost_id, '_room_image_id_'.$i, $room_image_id[$i]);
						}
					}
				}
				// Booking From
				update_post_meta($newpost_id, '_booking_type', sanitize_text_field($form_data['override_bookingf']));
				update_post_meta($newpost_id, '_booking_stcode', sanitize_text_field($form_data['booking_stcode']));
				update_post_meta($newpost_id, 'address', sanitize_text_field($form_data['address']));
				update_post_meta($newpost_id, 'latitude', sanitize_text_field($form_data['latitude']));
				update_post_meta($newpost_id, 'longitude', sanitize_text_field($form_data['longitude']));
				update_post_meta($newpost_id, 'city', sanitize_text_field($form_data['city']));
				update_post_meta($newpost_id, 'state', sanitize_text_field($form_data['state']));
				update_post_meta($newpost_id, 'area', sanitize_text_field($form_data['area']));
				update_post_meta($newpost_id, 'postcode', sanitize_text_field($form_data['postcode']));
				update_post_meta($newpost_id, 'country', sanitize_text_field($form_data['country']));
				update_post_meta($newpost_id, 'logo_image_id', $form_data['logo_image_id']);
				update_post_meta($newpost_id, 'image_gallery_ids', $form_data['gallery_image_ids']);
				update_post_meta($newpost_id, 'phone', sanitize_text_field($form_data['phone']));
				update_post_meta($newpost_id, 'fax', sanitize_text_field($form_data['fax']));
				update_post_meta($newpost_id, 'contact-email', sanitize_email($form_data['contact-email']));
				update_post_meta($newpost_id, 'contact_web', esc_url_raw($form_data['contact_web']));
				if(isset($form_data['vimeo'] )){
					update_post_meta($newpost_id, 'vimeo', sanitize_text_field($form_data['vimeo']));
					update_post_meta($newpost_id, 'youtube', sanitize_text_field($form_data['youtube']));
				}
				update_post_meta($newpost_id, 'facebook', sanitize_text_field($form_data['facebook']));
				update_post_meta($newpost_id, 'linkedin',sanitize_text_field( $form_data['linkedin']));
				update_post_meta($newpost_id, 'twitter', sanitize_text_field($form_data['twitter']));
				update_post_meta($newpost_id, 'pinterest', sanitize_text_field($form_data['pinterest']));
				update_post_meta($newpost_id, 'instagram', sanitize_text_field($form_data['instagram']));
				if(isset($form_data['event-title'])){
					update_post_meta($newpost_id, '_event_image_id', $form_data['event_image_id']);
					update_post_meta($newpost_id, 'event_title', sanitize_text_field($form_data['event-title']));
					update_post_meta($newpost_id, 'event_detail', sanitize_text_field($form_data['event-detail']));
				}
				include( wp_iv_directories_ABSPATH. 'inc/notification.php');
				echo json_encode(array("code" => "success","msg"=>esc_html__( 'Update Successfully', 'ivdirectories' )));
				exit(0);
			}
			public function get_unique_keyword_values( $post_type , $key = 'keyword'){
				global $wpdb;
				if( empty( $key ) ){
					return;
				}
				$res=array();
				$args = array(
				'post_type' => $post_type, // enter your custom post type
				'post_status' => 'publish',
				'posts_per_page'=> -1,  // overrides posts per page in theme settings
				);
				$query_auto = new WP_Query( $args );
				$posts_auto = $query_auto->posts;
				foreach($posts_auto as $post_a) {
					$res[]=$post_a->post_title;
				}
				return $res;
			}
			public function get_unique_post_meta_values( $post_type, $key = 'postcode' ){
				global $wpdb;
				if( empty( $key ) ){
					return;
				}
				$res = $wpdb->get_col( $wpdb->prepare( "
				SELECT DISTINCT pm.meta_value FROM {$wpdb->postmeta} pm
				LEFT JOIN {$wpdb->posts} p ON p.ID = pm.post_id
				WHERE p.post_type='{$post_type}' AND  pm.meta_key = '%s'
				", $key) );
				return $res;
			}
			public function listing_cities_func($atts = ''){
				ob_start();
				include( wp_iv_directories_template. 'listing/listing-cities.php');
				$content = ob_get_clean();
				return $content;
			}
			public function iv_directories_cancel_paypal(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'myaccount' ) ) {
					echo json_encode(array("msg"=>"Are you cheating:wpnonce?"));
					exit(0);
				}
				global $wpdb;
				global $current_user;
				parse_str($_POST['form_data'], $form_data);
				if( ! class_exists('Paypal' ) ) {
					include(wp_iv_directories_DIR . '/inc/class-paypal.php');
				}
				$post_name='iv_directories_paypal_setting';
				$row = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->posts WHERE post_name = '%s' ",$post_name ));
				$paypal_id='0';
				if(isset($row->ID )){
					$paypal_id= $row->ID;
				}
				$paypal_api_currency=get_post_meta($paypal_id, 'iv_directories_paypal_api_currency', true);
				$paypal_username=get_post_meta($paypal_id, 'iv_directories_paypal_username',true);
				$paypal_api_password=get_post_meta($paypal_id, 'iv_directories_paypal_api_password', true);
				$paypal_api_signature=get_post_meta($paypal_id, 'iv_directories_paypal_api_signature', true);
				$credentials = array();
				$credentials['USER'] = (isset($paypal_username)) ? $paypal_username : '';
				$credentials['PWD'] = (isset($paypal_api_password)) ? $paypal_api_password : '';
				$credentials['SIGNATURE'] = (isset($paypal_api_signature)) ? $paypal_api_signature : '';
				$paypal_mode=get_post_meta($paypal_id, 'iv_directories_paypal_mode', true);
				$currencyCode = $paypal_api_currency;
				$sandbox = ($paypal_mode == 'live') ? '' : 'sandbox.';
				$sandboxBool = (!empty($sandbox)) ? true : false;
				$paypal = new Paypal($credentials,$sandboxBool);
				$oldProfile = get_user_meta($current_user->ID,'iv_paypal_recurring_profile_id',true);
				if (!empty($oldProfile)) {
					$cancelParams = array(
					'PROFILEID' => $oldProfile,
					'ACTION' => 'Cancel'
					);
					$paypal -> request('ManageRecurringPaymentsProfileStatus',$cancelParams);
					update_user_meta($current_user->ID,'iv_paypal_recurring_profile_id','');
					update_user_meta($current_user->ID,'iv_cancel_reason', $form_data['cancel_text']);
					update_user_meta($current_user->ID,'iv_directories_payment_status', 'cancel');
					echo json_encode(array("code" => "success","msg"=>"Cancel Successfully"));
					exit(0);
					}else{
					echo json_encode(array("code" => "not","msg"=>"Unable to Cancel "));
					exit(0);
				}
			}
			public function  iv_directories_profile_stripe_upgrade(){
				include(wp_iv_directories_DIR . '/admin/files/lib/Stripe.php');
				global $wpdb;
				global $current_user;
				parse_str($_POST['form_data'], $form_data);
				$newpost_id='';
				$post_name='iv_directories_stripe_setting';
				$row = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->posts WHERE post_name = '%s' ",$post_name ));
				if(isset($row->ID )){
					$newpost_id= $row->ID;
				}
				$stripe_mode=get_post_meta( $newpost_id,'iv_directories_stripe_mode',true);
				if($stripe_mode=='test'){
					$stripe_api =get_post_meta($newpost_id, 'iv_directories_stripe_secret_test',true);
					}else{
					$stripe_api =get_post_meta($newpost_id, 'iv_directories_stripe_live_secret_key',true);
				}
				Stripe::setApiKey($stripe_api);
				// For  cancel ----
				$arb_status =	get_user_meta($current_user->ID, 'iv_directories_payment_status', true);
				$cust_id = get_user_meta($current_user->ID,'iv_directories_stripe_cust_id',true);
				$sub_id = get_user_meta($current_user->ID,'iv_directories_stripe_subscrip_id',true);
				if($sub_id!=''){
					try{
						$iv_cancel_stripe = Stripe_Customer::retrieve($form_data['cust_id']);
						$iv_cancel_stripe->subscriptions->retrieve($form_data['sub_id'])->cancel();
						} catch (Exception $e) {
					}
					update_user_meta($current_user->ID,'iv_directories_payment_status', 'cancel');
					update_user_meta($current_user->ID,'iv_directories_stripe_subscrip_id','');
				}
				// Start  New
				$response='';
				parse_str($_POST['form_data'], $form_data);
				include(wp_iv_directories_DIR . '/admin/pages/payment-inc/stripe-upgrade.php');
				echo json_encode(array("code" => "success","msg"=>$response));
				exit(0);
			}
			public function iv_directories_cancel_stripe(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'myaccount' ) ) {
					echo json_encode(array("msg"=>"Are you cheating:wpnonce?"));
					exit(0);
				}
				include(wp_iv_directories_DIR . '/admin/files/lib/Stripe.php');
				global $wpdb;
				global $current_user;
				parse_str($_POST['form_data'], $form_data);
				$newpost_id='';
				$post_name='iv_directories_stripe_setting';
				$row = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->posts WHERE post_name = '%s' ",$post_name ));
				if(isset($row->ID )){
					$newpost_id= $row->ID;
				}
				$stripe_mode=get_post_meta( $newpost_id,'iv_directories_stripe_mode',true);
				if($stripe_mode=='test'){
					$stripe_api =get_post_meta($newpost_id, 'iv_directories_stripe_secret_test',true);
					}else{
					$stripe_api =get_post_meta($newpost_id, 'iv_directories_stripe_live_secret_key',true);
				}
				parse_str($_POST['form_data'], $form_data);
				Stripe::setApiKey($stripe_api);
				try{
					$iv_cancel_stripe = Stripe_Customer::retrieve($form_data['cust_id']);
					$iv_cancel_stripe->subscriptions->retrieve($form_data['sub_id'])->cancel();
					} catch (Exception $e) {
				}
				update_user_meta($current_user->ID,'iv_cancel_reason', $form_data['cancel_text']);
				update_user_meta($current_user->ID,'iv_directories_payment_status', 'cancel');
				update_user_meta($current_user->ID,'iv_directories_stripe_subscrip_id','');
				echo json_encode(array("code" => "success","msg"=>"Cancel Successfully"));
				exit(0);
			}
			public function  iv_directories_stripe_form_func(){
				include(wp_iv_directories_ABSPATH.'files/short_code_file/iv_stripe_form_display.php');
			}
			public function iv_directories_update_setting_hide(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'myaccount' ) ) {
					echo json_encode(array("msg"=>"Are you cheating:wpnonce?"));
					exit(0);
				}
				global $current_user;
				parse_str($_POST['form_data'], $form_data);
				$mobile_hide=(isset($form_data['mobile_hide'])? sanitize_text_field($form_data['mobile_hide']):'');
				$email_hide=(isset($form_data['email_hide'])? sanitize_text_field($form_data['email_hide']):'');
				$phone_hide=(isset($form_data['phone_hide'])? sanitize_text_field($form_data['phone_hide']):'');
				update_user_meta($current_user->ID,'hide_email', $email_hide);
				update_user_meta($current_user->ID,'hide_phone', $phone_hide);
				update_user_meta($current_user->ID,'hide_mobile',$mobile_hide);
				echo json_encode(array("code" => "success","msg"=>esc_html__( 'Update Successfully', 'ivdirectories' )));
				exit(0);
			}
			public function iv_directories_update_setting_fb(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'myaccount' ) ) {
					echo json_encode(array("msg"=>"Are you cheating:wpnonce?"));
					exit(0);
				}
				global $current_user;
				parse_str($_POST['form_data'], $form_data);
				update_user_meta($current_user->ID,'twitter', sanitize_text_field($form_data['twitter']));
				update_user_meta($current_user->ID,'facebook', sanitize_text_field($form_data['facebook']));
				update_user_meta($current_user->ID,'linkedin', sanitize_text_field($form_data['linkedin']));
				echo json_encode(array("code" => "success","msg"=>esc_html__( 'Update Successfully', 'ivdirectories' )));
				exit(0);
			}
			public function iv_directories_update_setting_password(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'myaccount' ) ) {
					echo json_encode(array("msg"=>"Are you cheating:wpnonce?"));
					exit(0);
				}
				global $current_user;
				parse_str($_POST['form_data'], $form_data);
				if ( wp_check_password( $form_data['c_pass'], $current_user->user_pass, $current_user->ID) ){
					if($form_data['r_pass']!=$form_data['n_pass']){
						echo json_encode(array("code" => "not", "msg"=>esc_html__( 'New Password & Re Password are not same. ', 'ivdirectories' )));
						exit(0);
						}else{
						wp_set_password( $form_data['n_pass'], $current_user->ID);
						echo json_encode(array("code" => "success","msg"=>esc_html__( 'Update Successfully', 'ivdirectories' )));
						exit(0);
					}
					}else{
					echo json_encode(array("code" => "not", "msg"=>esc_html__( 'Current password is wrong.', 'ivdirectories' )));
					exit(0);
				}
			}
			public function iv_directories_update_profile_setting(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'myaccount' ) ) {
					echo json_encode(array("msg"=>"Are you cheating:wpnonce?"));
					exit(0);
				}
				if(array_key_exists('wp_capabilities',$form_data)){
					wp_die( 'Are you cheating:wp_capabilities?' );
				}
				global $current_user;
				parse_str($_POST['form_data'], $form_data);
				foreach ( $form_data as $field_key => $field_value ) {
					if($field_key!='wp_capabilities'){
						update_user_meta($current_user->ID,sanitize_text_field($field_key), sanitize_text_field($field_value));
					}
				}
				echo json_encode(array("code" => "success","msg"=>esc_html__( 'Update Successfully', 'ivdirectories' )));
				exit(0);
			}
			public function modify_contact_methods($profile_fields) {
				// Add new fields
				$profile_fields['phone'] = 'Phone Number';
				$profile_fields['twitter'] = 'Twitter Username';
				$profile_fields['facebook'] = 'Facebook URL';
				$profile_fields['gplus'] = 'Google+ URL';
				$profile_fields['linkedin'] = 'Linkedin';
				return $profile_fields;
			}
			public function iv_restrict_media_library( $wp_query ) {
				global $current_user, $pagenow;
				if( is_admin() && !current_user_can('edit_others_posts') ) {
					$wp_query->set( 'author', $current_user->ID );
					add_filter('views_edit-post', 'fix_post_counts');
					add_filter('views_upload', 'fix_media_counts');
				}
			}
			public function check_expiry_date($user) {
				include(wp_iv_directories_DIR . '/inc/check_expire_date.php');
			}
			public function iv_directories_update_profile_pic(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'myaccount' ) ) {
					echo json_encode(array("msg"=>"Are you cheating:wpnonce?"));
					exit(0);
				}
				global $current_user;
				if(isset($_REQUEST['profile_pic_url_1'])){
					$iv_profile_pic_url=$_REQUEST['profile_pic_url_1'];
					$attachment_thum=$_REQUEST['attachment_thum'];
					}else{
					$iv_profile_pic_url='';
					$attachment_thum='';
				}
				update_user_meta($current_user->ID, 'iv_profile_pic_thum', $attachment_thum);
				update_user_meta($current_user->ID, 'iv_profile_pic_url', $iv_profile_pic_url);
				echo json_encode('success');
				exit(0);
			}
			public function iv_directories_paypal_form_submit(  ) {
				include(wp_iv_directories_DIR . '/admin/pages/payment-inc/paypal-submit.php');
			}
			public function iv_directories_stripe_form_submit(  ) {
				include(wp_iv_directories_DIR . '/admin/pages/payment-inc/stripe-submit.php');
			}
			public function plugin_mce_css_iv_directories( $mce_css ) {
				if ( ! empty( $mce_css ) )
				$mce_css .= ',';
				$mce_css .= plugins_url( 'admin/files/css/iv-bootstrap.css', __FILE__ );
				return $mce_css;
			}
			/***********************************
				* Adds a meta box to the post editing screen
			*/
			public function prfx_custom_meta_iv_listing() {
				$default_fields = array();
				$field_set=get_option('_iv_directory_url_postype' );
				if($field_set!=""){
					$default_fields=get_option('_iv_directory_url_postype' );
					}else{
					$default_fields['hotel']='Hotel';
					$default_fields['restaurant']='Restaurant';
					$default_fields['bar']='Bar';
				}
				foreach ( $default_fields as $field_key => $field_value ) {
					add_meta_box('prfx_meta', esc_html__(' Claim Approve', 'ivdirectories'), array($this, 'iv_listing_meta_callback'),$field_key,'side');
					add_meta_box('prfx_meta', esc_html__(' Listing Data', 'ivdirectories'), array($this, 'iv_listing_meta_callback_full_data'),$field_key,'advanced');
				}
			}
			public function iv_directories_check_coupon(){
				global $wpdb;
				$coupon_code=sanitize_text_field($_REQUEST['coupon_code']);
				$package_id=sanitize_text_field($_REQUEST['package_id']);
				$package_amount=get_post_meta($package_id, 'iv_directories_package_cost',true);
				$api_currency =$_REQUEST['api_currency'];
				$post_cont = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->posts WHERE post_title = '%s' and  post_type='iv_coupon'" , $coupon_code));
				if(isset($post_cont->post_title) && $package_amount>0){
					$coupon_name = $post_cont->post_title;
					$current_date=$today = date("m/d/Y");
					$start_date=get_post_meta($post_cont->ID, 'iv_coupon_start_date', true);
					$end_date=get_post_meta($post_cont->ID, 'iv_coupon_end_date', true);
					$coupon_used=get_post_meta($post_cont->ID, 'iv_coupon_used', true);
					$coupon_limit=get_post_meta($post_cont->ID, 'iv_coupon_limit', true);
					$dis_amount=get_post_meta($post_cont->ID, 'iv_coupon_amount', true);
					$package_ids =get_post_meta($post_cont->ID, 'iv_coupon_pac_id', true);
					$all_pac_arr= explode(",",$package_ids);
					$today_time = strtotime($current_date);
					$start_time = strtotime($start_date);
					$expire_time = strtotime($end_date);
					if(in_array('0', $all_pac_arr)){
						$pac_found=1;
						}else{
						if(in_array($package_id, $all_pac_arr)){
							$pac_found=1;
							}else{
							$pac_found=0;
						}
					}
					$recurring = get_post_meta( $package_id,'iv_directories_package_recurring',true);
					if($today_time >= $start_time && $today_time<=$expire_time && $coupon_used<=$coupon_limit && $pac_found == '1' && $recurring!='on' ){
						$total = $package_amount -$dis_amount;
						$coupon_type= get_post_meta($post_cont->ID, 'iv_coupon_type', true);
						if($coupon_type=='percentage'){
							$dis_amount= $dis_amount * $package_amount/100;
							$total = $package_amount -$dis_amount ;
						}
						echo json_encode(array('code' => 'success',
						'dis_amount' => $dis_amount.' '.$api_currency,
						'gtotal' => $total.' '.$api_currency,
						'p_amount' => $package_amount.' '.$api_currency,
						));
						exit(0);
						}else{
						$dis_amount='';
						$total=$package_amount;
						echo json_encode(array('code' => 'not-success-2',
						'dis_amount' => '',
						'gtotal' => $total.' '.$api_currency,
						'p_amount' => $package_amount.' '.$api_currency,
						));
						exit(0);
					}
					}else{
					if($package_amount=="" or $package_amount=="0"){$package_amount='0';}
					$dis_amount='';
					$total=$package_amount;
					echo json_encode(array('code' => 'not-success-1',
					'dis_amount' => '',
					'gtotal' => $total.' '.$api_currency,
					'p_amount' => $package_amount.' '.$api_currency,
					));
					exit(0);
				}
			}
			public function iv_directories_check_package_amount(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'signup' ) ) {
					echo json_encode(array("msg"=>"Are you cheating:wpnonce?"));
					exit(0);
				}
				global $wpdb;
				$coupon_code=isset($_REQUEST['coupon_code']);
				$package_id=$_REQUEST['package_id'];
				if( get_post_meta( $package_id,'iv_directories_package_recurring',true) =='on'  ){
					$package_amount=get_post_meta($package_id, 'iv_directories_package_recurring_cost_initial', true);
					}else{
					$package_amount=get_post_meta($package_id, 'iv_directories_package_cost',true);
				}
				$api_currency =$_REQUEST['api_currency'];
				$post_cont = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->posts WHERE post_title = '%s' and  post_type='iv_coupon'" , $coupon_code));
				if(isset($post_cont->post_title)){
					$coupon_name = $post_cont->post_title;
					$current_date=$today = date("m/d/Y");
					$start_date=get_post_meta($post_cont->ID, 'iv_coupon_start_date', true);
					$end_date=get_post_meta($post_cont->ID, 'iv_coupon_end_date', true);
					$coupon_used=get_post_meta($post_cont->ID, 'iv_coupon_used', true);
					$coupon_limit=get_post_meta($post_cont->ID, 'iv_coupon_limit', true);
					$dis_amount=get_post_meta($post_cont->ID, 'iv_coupon_amount', true);
					$package_ids =get_post_meta($post_cont->ID, 'iv_coupon_pac_id', true);
					$all_pac_arr= explode(",",$package_ids);
					$today_time = strtotime($current_date);
					$start_time = strtotime($start_date);
					$expire_time = strtotime($end_date);
					$pac_found= in_array($package_id, $all_pac_arr);
					if($today_time >= $start_time && $today_time<=$expire_time && $coupon_used<=$coupon_limit && $pac_found=="1"){
						$total = $package_amount -$dis_amount;
						echo json_encode(array('code' => 'success',
						'dis_amount' => $api_currency.' '.$dis_amount,
						'gtotal' => $api_currency.' '.$total,
						'p_amount' => $api_currency.' '.$package_amount,
						));
						exit(0);
						}else{
						$dis_amount='--';
						$total=$package_amount;
						echo json_encode(array('code' => 'not-success',
						'dis_amount' => $api_currency.' '.$dis_amount,
						'gtotal' => $api_currency.' '.$total,
						'p_amount' => $api_currency.' '.$package_amount,
						));
						exit(0);
					}
					}else{
					$dis_amount='--';
					$total=$package_amount;
					echo json_encode(array('code' => 'not-success',
					'dis_amount' => $api_currency.' '.$dis_amount,
					'gtotal' => $api_currency.' '.$total,
					'p_amount' => $api_currency.' '.$package_amount,
					));
					exit(0);
				}
			}
			/**
				* Outputs the content of the meta box
			*/
			public function iv_listing_meta_callback($post) {
				wp_nonce_field(basename(__FILE__), 'prfx_nonce');
				include ('admin/pages/metabox.php');
			}
			public function iv_listing_meta_callback_full_data($post) {
				wp_nonce_field(basename(__FILE__), 'prfx_nonce');
				include ('admin/pages/metabox_full_data.php');
			}
			public function iv_listing_meta_save($post_id) {
				global $wpdb;
				$is_autosave = wp_is_post_autosave($post_id);
				if (isset($_REQUEST['iv_listing_approve'])) {
					if($_REQUEST['iv_listing_approve']=='yes'){
						update_post_meta($post_id, 'iv_listing_approve', $_REQUEST['iv_listing_approve']);
						// Set new user for post
						$sql=$wpdb->prepare("UPDATE  $wpdb->posts SET post_author='%s'  WHERE ID='%s'" ,$_REQUEST['iv_directories_author_id'],$post_id);
						$wpdb->query($sql);
					}
				}
				if (isset($_REQUEST['listing_data_submit'])) {
					$newpost_id=$post_id;
					$default_fields = array();
					$field_set=get_option('iv_directories_fields' );
					if($field_set!=""){
						$default_fields=get_option('iv_directories_fields' );
					}else{
						$default_fields['Rooms']='Rooms';
						$default_fields['suites']='Suites';
						$default_fields['Rating_stars']='Rating Stars';
						$default_fields['CHECK_IN']='Check In';
						$default_fields['CHECK_out']='Check Out';
						$default_fields['Cancellation']='Cancellation';
						$default_fields['Pets']='Pets';
						$default_fields['Children_and_Extra_Beds']='Children and Extra Beds';
					}
					if(is_array($default_fields )){
						foreach( $default_fields as $field_key => $field_value ) {
							if(isset($_REQUEST[$field_key])){
								update_post_meta($newpost_id, sanitize_text_field($field_key), sanitize_text_field($_REQUEST[$field_key]));
							}
						}
					}
					$opening_day=array();
					if(isset($_REQUEST['day_name'] )){
						$day_name= $_REQUEST['day_name'] ;
						$day_value1 = $_REQUEST['day_value1'] ;
						$day_value2 = $_REQUEST['day_value2'] ;
						$i=0;
						foreach($day_name  as $one_meta){
							if(isset($day_name[$i]) and isset($day_value1[$i]) ){
								if($day_name[$i] !=''){
									$opening_day[sanitize_text_field($day_name[$i])]=sanitize_text_field($day_value1[$i]).'|'.sanitize_text_field($day_value2[$i]);
								}
							}
							$i++;
						}
						update_post_meta($newpost_id, '_opening_time', $opening_day);
					}
					// For Specialities Save
					$Specialities_all='';
					if(isset($_REQUEST['Specialities_arr'] )){
						$Specialities_name= $_REQUEST['Specialities_arr'] ;
						$i=0;$Specialities_all='';
						foreach($Specialities_name  as $one_Specialities){
							$Specialities_all= $Specialities_all.",".sanitize_text_field($one_Specialities);
						}
						update_post_meta($newpost_id, 'Specialities', $Specialities_all);
					}
					// For Awards Save
					// Delete 1st
					$i=0;
					for($i=0;$i<20;$i++){
						delete_post_meta($newpost_id, '_award_title_'.$i);
						delete_post_meta($newpost_id, '_award_description_'.$i);
						delete_post_meta($newpost_id, '_award_year_'.$i);
						delete_post_meta($newpost_id, '_award_image_id_'.$i);
					}
					// Delete End
					if(isset($_REQUEST['award_title'] )){
						$award_title= $_REQUEST['award_title'];
						$award_description= $_REQUEST['award_description'];
						$award_year= $_REQUEST['award_year'];
						$award_image_id= (isset($_REQUEST['award_image_id']) ? $_REQUEST['award_image_id']:'');
						$i=0;
						for($i=0;$i<20;$i++){
							if(isset($award_title[$i])){
								update_post_meta($newpost_id, '_award_title_'.$i, sanitize_text_field($award_title[$i]));
							}
							if(isset($award_description[$i])){
								update_post_meta($newpost_id, '_award_description_'.$i, sanitize_text_field($award_description[$i]));
							}
							if(isset($award_year[$i])){
								update_post_meta($newpost_id, '_award_year_'.$i, sanitize_text_field($award_year[$i]));
							}
							if(isset($award_image_id[$i])){
								update_post_meta($newpost_id, '_award_image_id_'.$i, $award_image_id[$i]);
							}
						}
					}
					// For Menu Save
					// Delete 1st
					$i=0;
					for($i=0;$i<50;$i++){
						delete_post_meta($newpost_id, '_menu_title_'.$i);
						delete_post_meta($newpost_id, '_menu_description_'.$i);
						delete_post_meta($newpost_id, '_menu_price_'.$i);
						delete_post_meta($newpost_id, '_menu_order_'.$i);
						delete_post_meta($newpost_id, '_menu_image_id_'.$i);
					}
					// Delete End
					if(isset($_REQUEST['menu_title'] )){
						$menu_title= $_REQUEST['menu_title'];
						$menu_description= $_REQUEST['menu_description'];
						$menu_price= $_REQUEST['menu_price'];
						$menu_image_id= (isset($_REQUEST['menu_image_id']) ? $_REQUEST['menu_image_id']:'');
						$menu_order	=$_REQUEST['menu_order'];
						$i=0;
						for($i=0;$i<50;$i++){
							if(isset($menu_title[$i])){
								update_post_meta($newpost_id, '_menu_title_'.$i, sanitize_text_field($menu_title[$i]));
							}
							if(isset($menu_description[$i])){
								update_post_meta($newpost_id, '_menu_description_'.$i, sanitize_text_field($menu_description[$i]));
							}
							if(isset($menu_price[$i])){
								update_post_meta($newpost_id, '_menu_price_'.$i, sanitize_text_field($menu_price[$i]));
							}
							if(isset($menu_order[$i])){
								update_post_meta($newpost_id, '_menu_order_'.$i, sanitize_text_field($menu_order[$i]));
							}
							if(isset($menu_image_id[$i])){
								update_post_meta($newpost_id, '_menu_image_id_'.$i, $menu_image_id[$i]);
							}
						}
					}
					// For room Save
					// Delete 1st
					$i=0;
					for($i=0;$i<50;$i++){
						delete_post_meta($newpost_id, '_room_title_'.$i);
						delete_post_meta($newpost_id, '_room_description_'.$i);
						delete_post_meta($newpost_id, '_room_price_'.$i);
						delete_post_meta($newpost_id, '_room_order_'.$i);
						delete_post_meta($newpost_id, '_room_image_id_'.$i);
					}
					// Delete End
					if(isset($_REQUEST['room_title'] )){
						$room_title= $_REQUEST['room_title'];
						$room_description= $_REQUEST['room_description'];
						$room_price= $_REQUEST['room_price'];
						$room_image_id= (isset($_REQUEST['room_image_id']) ? $_REQUEST['room_image_id']:'');
						$room_order	=$_REQUEST['room_order'];
						$i=0;
						for($i=0;$i<50;$i++){
							if(isset($room_title[$i])){
								update_post_meta($newpost_id, '_room_title_'.$i, sanitize_text_field($room_title[$i]));
							}
							if(isset($room_description[$i])){
								update_post_meta($newpost_id, '_room_description_'.$i, sanitize_text_field($room_description[$i]));
							}
							if(isset($room_price[$i])){
								update_post_meta($newpost_id, '_room_price_'.$i, sanitize_text_field($room_price[$i]));
							}
							if(isset($room_order[$i])){
								update_post_meta($newpost_id, '_room_order_'.$i, sanitize_text_field($room_order[$i]));
							}
							if(isset($room_image_id[$i])){
								update_post_meta($newpost_id, '_room_image_id_'.$i, $room_image_id[$i]);
							}
						}
					}
					// Booking From
					if(isset($_REQUEST['override_bookingf'] )){
						update_post_meta($newpost_id, '_booking_type', sanitize_text_field($_REQUEST['override_bookingf']));
					}
					if(isset($_REQUEST['booking_stcode'] )){
						update_post_meta($newpost_id, '_booking_stcode', sanitize_text_field($_REQUEST['booking_stcode']));
					}
					if(isset($_REQUEST['address'] )){
						update_post_meta($newpost_id, 'address', sanitize_text_field($_REQUEST['address']));
					}
					if(isset($_REQUEST['latitude'] )){
						update_post_meta($newpost_id, 'latitude', sanitize_text_field($_REQUEST['latitude']));
					}
					if(isset($_REQUEST['longitude'] )){
						update_post_meta($newpost_id, 'longitude', sanitize_text_field($_REQUEST['longitude']));
					}
					if(isset($_REQUEST['city'] )){
						update_post_meta($newpost_id, 'city', sanitize_text_field($_REQUEST['city']));
					}
					if(isset($_REQUEST['area'] )){
						update_post_meta($newpost_id, 'area', sanitize_text_field($_REQUEST['area']));
					}
					if(isset($_REQUEST['postcode'] )){
						update_post_meta($newpost_id, 'postcode', sanitize_text_field($_REQUEST['postcode']));
					}
					if(isset($_REQUEST['country'] )){
						update_post_meta($newpost_id, 'country', sanitize_text_field($_REQUEST['country']));
					}
					if(isset($_REQUEST['logo_image_id'] )){
						update_post_meta($newpost_id, 'logo_image_id', sanitize_text_field($_REQUEST['logo_image_id']));
					}
					if(isset($_REQUEST['gallery_image_ids'] )){
						update_post_meta($newpost_id, 'image_gallery_ids', sanitize_text_field($_REQUEST['gallery_image_ids']));
					}
					if(isset($_REQUEST['phone'] )){
						update_post_meta($newpost_id, 'phone', sanitize_text_field($_REQUEST['phone']));
					}
					if(isset($_REQUEST['fax'] )){
						update_post_meta($newpost_id, 'fax', sanitize_text_field($_REQUEST['fax']));
					}
					if(isset($_REQUEST['contact-email'] )){
						update_post_meta($newpost_id, 'contact-email', sanitize_text_field($_REQUEST['contact-email']));
					}
					if(isset($_REQUEST['contact_web'] )){
						update_post_meta($newpost_id, 'contact_web', sanitize_text_field($_REQUEST['contact_web']));
					}
					if(isset($_REQUEST['facebook'] )){
						update_post_meta($newpost_id, 'facebook', sanitize_text_field($_REQUEST['facebook']));
					}
					if(isset($_REQUEST['linkedin'] )){
						update_post_meta($newpost_id, 'linkedin', sanitize_text_field($_REQUEST['linkedin']));
					}
					if(isset($_REQUEST['twitter'] )){
						update_post_meta($newpost_id, 'twitter', sanitize_text_field($_REQUEST['twitter']));
					}
					if(isset($_REQUEST['pinterest'] )){
						update_post_meta($newpost_id, 'pinterest', sanitize_text_field($_REQUEST['pinterest']));
					}
					if(isset($_REQUEST['instagram'] )){
						update_post_meta($newpost_id, 'instagram', sanitize_text_field($_REQUEST['instagram']));
					}
					
					if(isset($_REQUEST['vimeo'] )){
						update_post_meta($newpost_id, 'vimeo', sanitize_text_field($_REQUEST['vimeo']));
						update_post_meta($newpost_id, 'youtube', sanitize_text_field($_REQUEST['youtube']));
					}
					
					if(isset($_REQUEST['event-title'])){
						update_post_meta($newpost_id, '_event_image_id', sanitize_text_field($_REQUEST['event_image_id']));
						update_post_meta($newpost_id, 'event_title', sanitize_text_field($_REQUEST['event-title']));
						update_post_meta($newpost_id, 'event_detail', sanitize_text_field($_REQUEST['event-detail']));
					}
					delete_post_meta($newpost_id, 'eplisting-category');
					delete_post_meta($newpost_id, 'eplisting-tag');
				}
			}
			public function iv_content_protected_pages($content) {
				$current_user = wp_get_current_user();
				global $post ;
				ob_start();
				$active_module=get_option('_iv_directories_active_visibility_page');
				if(!isset($post->post_type)){
					return $content;
				}
				if($active_module=='yes' AND $post->post_type=='page'){
					if(isset($current_user->ID) AND $current_user->ID!=''){
						$user_role= $current_user->roles[0];
						if(isset($current_user->roles[0]) and $current_user->roles[0]=='administrator'){
							return $content;
						}
						$message=get_option('_iv_visibility_login_message');
						}else{
						$user_role= 'visitor';
						$message=get_option('_iv_visibility_visitor_message');
					}
					$store_array=get_option('_iv_visibility_serialize_page_role');
					if(isset($store_array[$user_role]))
					{
						if(in_array($post->post_name, $store_array[$user_role])){
							return $content;
							}else{
							$content = ob_get_clean();
							$content =  $message;
							return $content;
						}
						}else{
						$content = ob_get_clean();
						$content =  $message;
						return $content;
					}
				}
				return $content;
			}
			public function iv_directories_cpt_change(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'myaccount' ) ) {
					echo json_encode(array("msg"=>"Are you cheating:wpnonce?"));
					exit(0);
				}
				$custom_post_type = $_POST['select_data'];
				$args2 = array(
				'type'                     => $custom_post_type,
				'orderby'                  => 'name',
				'order'                    => 'ASC',
				'hide_empty'        	   => false,
				'hierarchical'             => 0,
				'exclude'                  => '',
				'include'                  => '',
				'number'                   => '',
				'taxonomy'                 => $custom_post_type.'-category',
				'pad_counts'               => false
				);
				$categories = get_categories( $args2 );
				if ( $categories && !is_wp_error( $categories ) ) :
				$val_cat2='<select name="postcats" id="postcats" class="form-control">';
				$val_cat2=$val_cat2.'<option  value="">'.esc_html__('Any Category','ivdirectories').'</option>';
				foreach ( $categories as $term ) {
					$val_cat2=$val_cat2. '<option  value="'.$term->slug.'" >'.$term->name.'</option>';
				}
				$val_cat2=$val_cat2.'</select>';
				endif;
				$args3 = array(
				'type'                     => $custom_post_type,
				'orderby'                  => 'name',
				'order'                    => 'ASC',
				'hide_empty'               => 0,
				'hierarchical'             => 1,
				'exclude'                  => '',
				'include'                  => '',
				'number'                   => '',
				'taxonomy'                 => $custom_post_type.'_tag',
				'pad_counts'               => false
				);
				$tags='';
				$p_tag = get_categories( $args3 );
				if ( $p_tag && !is_wp_error( $p_tag ) ) :
				foreach ( $p_tag as $term ) {
					$tags=$tags.'<div class="col-md-4"><label class="form-group"><input type="checkbox" name="tag_arr[]" id="tag_arr[]" value="'. $term->slug.'"> '.$term->name.'</label></div>';
				}
				endif;
				echo json_encode(array("msg" => $val_cat2,"tags" => $tags));
				exit(0);
			}
			public function iv_directories_booking_send(){
					if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'contact' ) ) {
						echo json_encode(array("msg"=>"Are you cheating:wpnonce?"));
						exit(0);
					}
					parse_str($_POST['form_data'], $form_data);
					include( wp_iv_directories_ABSPATH. 'inc/booking-mail.php');
					echo json_encode(array("msg" => 'Message Sent'));
					exit(0);

				}
			public function iv_directories_content_protected($content) {
				$current_user = wp_get_current_user();
				global $post ;
				$active_module=get_option('_iv_directories_active_visibility');
				ob_start();
				if($active_module=='yes' AND $post->post_type=='post'){
					if(isset($current_user->ID) AND $current_user->ID!=''){
						$user_role= $current_user->roles[0];
						if(isset($current_user->roles[0]) and $current_user->roles[0]=='administrator'){
							return $content;
						}
						$message=get_option('_iv_visibility_login_message');
						$iv_redirect = get_option( '_iv_directories_profile_page');
						$reg_page= '<a href="'.get_permalink( $iv_redirect).'?&profile=level "> Here </a';
						$message= str_replace('[here_link]', $reg_page, $message);
						}else{
						$user_role= 'visitor';
						$message=get_option('_iv_visibility_visitor_message');
						$iv_redirect = get_option( '_iv_directories_login_page');
						$reg_page= '<a href="'.get_permalink( $iv_redirect).' "> Here </a';
						$message= str_replace('[here_link]', $reg_page, $message);
					}
					$post_category='';
					if(get_the_category($post->ID)){
						$post_category = get_the_category($post->ID);  // the value is recieved properly
						if(isset($post_category[0]->category_nicename)){
							$post_category=$post_category[0]->category_nicename;
						}
					}
					$store_array=get_option('_iv_visibility_serialize_role');
					if(isset($store_array[$user_role]))
					{
						if(in_array($post_category, $store_array[$user_role])){
							return $content;
							}else{
							$content = ob_get_clean();
							$content =  $message;
							return $content;
						}
						}else{
						$content='';
						$content = ob_get_clean();
						$content =  $message;
						return $content;
					}
					$output='';
					$output = $content;
				}
				return $content;
			}
			/**
				* Checks that the WordPress setup meets the plugin requirements
				* @global string $wp_version
				* @return boolean
			*/
			private function check_requirements() {
				global $wp_version;
				if (!version_compare($wp_version, $this->wp_version, '>=')) {
					add_action('admin_notices', 'wp_iv_directories::display_req_notice');
					return false;
				}
				return true;
			}
			/**
				* Display the requirement notice
				* @static
			*/
			static function display_req_notice() {
				global $wp_iv_directories;
				echo '<div id="message" class="error"><p><strong>';
				echo esc_html__('Sorry, BootstrapPress re requires WordPress ' . $wp_iv_directories->wp_version . ' or higher.
				Please upgrade your WordPress setup', 'ivdirectories');
				echo '</strong></p></div>';
			}
			public function iv_directories_user_exist_check(){
				global $wpdb;
				parse_str($_POST['form_data'], $data_a2);
				if(isset($data_a2['contact_captcha'])){
					$captcha_answer="";
					if(isset($data_a2['captcha_answer'])){
						$captcha_answer=$data_a2['captcha_answer'];
					}
					if($data_a2['contact_captcha']!=$captcha_answer){
						echo json_encode('captcha_error');
						exit(0);
					}
				}
				$userdata = array();
				$user_name='';
				if(isset($data_a2['iv_member_user_name'])){
					$userdata['user_login']=$data_a2['iv_member_user_name'];
				}
				if(isset($data_a2['iv_member_email'])){
					$userdata['user_email']=$data_a2['iv_member_email'];
				}
				if(isset($data_a2['iv_member_password'])){
					$userdata['user_pass']=$data_a2['iv_member_password'];
				}
				if($userdata['user_login']!='' and $userdata['user_email']!='' and $userdata['user_pass']!='' ){
					$user_id = username_exists( $userdata['user_login'] );
					if ( !$user_id and email_exists($userdata['user_email']) == false ) {
						echo json_encode('success');
						exit(0);
						} else {
						echo json_encode('User or Email exists');
						exit(0);
					}
				}
			}
			private function load_dependencies() {
				// Admin Panel
				if (is_admin()) {
					include ('admin/notifications.php');
					include ('admin/admin.php');
				}
				// Front-End Site
				if (!is_admin()) {
				}
				// Global
				include ('inc/widget.php');
			}
			/**
				* Called every time the plug-in is activated.
			*/
			public function activate() {
				include ('install/install.php');
			}
			/**
				* Called when the plug-in is deactivated.
			*/
			public function deactivate() {
				global $wpdb;
				$page_name='price-table';
				$query = $wpdb->prepare("delete from {$wpdb->prefix}posts where  post_name='%s' LIMIT 1" ,$page_name);
				$wpdb->query($query);
				$page_name='registration';
				$query = $wpdb->prepare("delete from {$wpdb->prefix}posts where  post_name='%s' LIMIT 1" ,$page_name);
				$wpdb->query($query);
				$page_name='my-account';
				$query = $wpdb->prepare("delete from {$wpdb->prefix}posts where  post_name='%s' LIMIT 1" ,$page_name);
				$wpdb->query($query);
				$page_name='profile-public';
				$query = $wpdb->prepare("delete from {$wpdb->prefix}posts where  post_name='%s' LIMIT 1" ,$page_name);
				$wpdb->query($query);
				$page_name='thank-you';
				$query = $wpdb->prepare("delete from {$wpdb->prefix}posts where  post_name='%s' LIMIT 1" ,$page_name);
				$wpdb->query($query);
				$page_name='login';
				$query = $wpdb->prepare("delete from {$wpdb->prefix}posts where  post_name='%s' LIMIT 1" ,$page_name);
				$wpdb->query($query);
				$page_name='user-directory';
				$query = $wpdb->prepare("delete from {$wpdb->prefix}posts where  post_name='%s' LIMIT 1" ,$page_name);
				$wpdb->query($query);
				$page_name='iv-reminder-email-cron-job';
				$query = $wpdb->prepare("delete from {$wpdb->prefix}posts where  post_name='%s' LIMIT 1" ,$page_name);
				$wpdb->query($query);
			}
			/**
				* Called when the plug-in is uninstalled
			*/
			static function uninstall() {
			}
			/**
				* Register the widgets
			*/
			public function register_widget() {
			}
			/**
				* Internationalization
			*/
			public function i18n() {
				load_plugin_textdomain('ivdirectories', false, basename(dirname(__FILE__)) . '/languages/' );
			}
			/**
				* Starts the plug-in main functionality
			*/
			public function start() {
			}
			public function iv_directories_price_table_func($atts = '', $content = '') {
				ob_start();						  //include the specified file
				if(isset($atts['style']) and $atts['style']!="" ){
					$tempale=$atts['style'];
					}else{
					if(get_option('iv_directories_price-table')){
						$tempale=	get_option('iv_directories_price-table');
						}else{
						$tempale=	'style-1';
					}
				}
				ob_start();						  //include the specified file
				if($tempale=='style-1'){
					include( wp_iv_directories_template. 'price-table/price-table-1.php');
				}
				if($tempale=='style-2'){
					include( wp_iv_directories_template. 'price-table/price-table-2.php');
				}
				if($tempale=='style-3'){
					include( wp_iv_directories_template. 'price-table/price-table-3.php');
				}
				if($tempale=='style-4'){
					include( wp_iv_directories_template. 'price-table/price-table-4.php');
				}
				if($tempale=='style-5'){
					include( wp_iv_directories_template. 'price-table/price-table-5.php');
				}
				if($tempale=='style-6'){
					include( wp_iv_directories_template. 'price-table/price-table-6.php');
				}
				if($tempale=='style-7'){
					include( wp_iv_directories_template. 'price-table/price-table-7.php');
				}
				$content = ob_get_clean();
				return $content;
			}
			public function iv_directories_search_func($atts = ''){
				ob_start();
				include( wp_iv_directories_template. 'listing/slider-search.php');
				$content = ob_get_clean();
				return $content;
			}
			public function iv_archive_directories_func(){
				ob_start();
				$template_path=wp_iv_directories_template.'directories/';
				include( $template_path. 'archive-directories.php');
				$content = ob_get_clean();
				return $content;
			}
			public function iv_directories_form_wizard_func($atts = '') {
				global $current_user;
				$template_path=wp_iv_directories_template.'signup/';
				ob_start();
				if($current_user->ID==0){
					$signup_access= get_option('users_can_register');
					if($signup_access=='0'){
						esc_html_e( 'Sorry! You are not allowed for signup.', 'ivdirectories' );
						}else{
						include( $template_path. 'wizard-style-2.php');
					}
					}else{
					include( wp_iv_directories_template. 'private-profile/profile-template-1.php');
				}
				$content = ob_get_clean();
				return $content;
			}
			public function iv_directories_profile_template_func($atts = '') {
				global $current_user;
				ob_start();
				if($current_user->ID==0){
					include(wp_iv_directories_template. 'private-profile/profile-login.php');
					}else{
					$tempale=get_option('iv_directories_profile-template');
					//include the specified file
					if($tempale=='style-1'){
						include( wp_iv_directories_template. 'private-profile/profile-template-1.php');
					}
					if($tempale=='style-2'){
						include( wp_iv_directories_template. 'private-profile/profile-template-1.php');
					}
				}
				$content = ob_get_clean();
				return $content;
			}
			public function iv_directories_reminder_email_cron_func ($atts = ''){
				include( wp_iv_directories_ABSPATH. 'inc/reminder-email-cron.php');
			}
			public function iv_directories_cron_job(){
				include( wp_iv_directories_ABSPATH. 'inc/all_cron_job.php');
				exit(0);
			}
			public function listing_categories_func($atts = ''){
				ob_start();
				include( wp_iv_directories_template. 'listing/listing_categories.php');
				$content = ob_get_clean();
				return $content;
			}
			public function listing_categories_tree_func($atts = ''){
				ob_start();
				include( wp_iv_directories_template. 'listing/listing_categories_tree.php');
				$content = ob_get_clean();
				return $content;
			}
			public function directorypro_map_func($atts = ''){
				ob_start();
				include( wp_iv_directories_template. 'directories/directories-map.php');
				$content = ob_get_clean();
				return $content;
			}
			public function listing_featured_func($atts = ''){
				ob_start();
				include( wp_iv_directories_template. 'listing/listing_featured.php');
				$content = ob_get_clean();
				return $content;
			}
			public function listing_archive_layout_func($atts = ''){
				ob_start();
				include( wp_iv_directories_template. 'listing/archive-listing.php');
				$content = ob_get_clean();
				return $content;
			}
			public function listing_archive_func($atts = ''){
				ob_start();
				include( wp_iv_directories_template. 'listing/archive-listing.php');
				$content = ob_get_clean();
				return $content;
			}
			public function listing_grid_filter_func($atts = ''){
				ob_start();
				include( wp_iv_directories_template. 'listing/archive-listing.php');
				$content = ob_get_clean();
				return $content;
			}
			public function listing_grid_alphabet_func($atts = ''){
				ob_start();
				include( wp_iv_directories_template. 'listing/archive-listing-alphabet.php');
				$content = ob_get_clean();
				return $content;
			}
			public function listing_filter_func($atts = ''){
				ob_start();
				include( wp_iv_directories_template. 'listing/listing_filter.php');
				$content = ob_get_clean();
				return $content;
			}
			public function iv_directories_user_directory_func($atts = ''){
				global $current_user;
				if(isset($atts['style']) and $atts['style']!="" ){
					$tempale=$atts['style'];
					}else{
					$tempale=get_option('iv_directories_user_directory');
				}
				if($tempale==''){
					$tempale='style-2';
				}
				ob_start();						  //include the specified file
				if($tempale=='style-1'){
					include( wp_iv_directories_template. 'user-directory/directory-template-1.php');
				}
				if($tempale=='style-2'){
					include( wp_iv_directories_template. 'user-directory/directory-template-2.php');
				}
				if($tempale=='style-3'){
					include( wp_iv_directories_template. 'user-directory/directory-template-3.php');
				}
				$content = ob_get_clean();
				return $content;
			}
			public function iv_directories_profile_public_func($atts = '') {
				ob_start();						  //include the specified file
				include( wp_iv_directories_template. 'profile-public/profile-template-2.php');
				$content = ob_get_clean();
				return $content;
			}
			public function get_search_listing($postcats, $lat=0,$lng=0,$radius=3){
				global $wpdb;
				if($radius==""){$radius='50';}
				if($lat==""){$lat='0';}
				if($lng==""){$lng='0';}
				$results = $wpdb->get_results("SELECT p.ID,
				ACOS(SIN(RADIANS($lat))*SIN(RADIANS(pm1.meta_value))+COS(RADIANS($lat  ))*COS(RADIANS(pm1.meta_value))*COS(RADIANS(pm2.meta_value)-RADIANS($lng))) * 6387.7 AS distance
				FROM $wpdb->posts p
				LEFT JOIN wp_postmeta AS pm1 ON ( p.ID = pm1.post_id AND pm1.meta_key = 'latitude' )
				LEFT JOIN wp_postmeta AS pm2 ON ( p.ID = pm2.post_id AND pm2.meta_key = 'longitude' )
				WHERE post_type = 'directories' AND post_status = 'publish'
				HAVING distance <= $radius
				ORDER BY distance ASC;");
				$ids='';
				foreach($results as $row){
					$ids=$row->ID.',';
				}
				return $ids;
			}
			public function get_nearest_listing($lat=0,$lng=0,$radius=3){
				global $wpdb;
				if($radius==""){$radius='50';}
				if($lat==""){$lat='0';}
				if($lng==""){$lng='0';}
				$dir_search_redius=get_option('_dir_search_redius');
				$for_option_redius='6387.7';
				if($dir_search_redius=="Miles"){$for_option_redius='3959';}else{$for_option_redius='6387.7'; }
				$results = $wpdb->get_results("SELECT p.*, pm1.meta_value as lat, pm2.meta_value as lon,
				ACOS(SIN(RADIANS($lat))*SIN(RADIANS(pm1.meta_value))+COS(RADIANS($lat  ))*COS(RADIANS(pm1.meta_value))*COS(RADIANS(pm2.meta_value)-RADIANS($lng))) * ".$for_option_redius." AS distance
				FROM $wpdb->posts p
				LEFT JOIN wp_postmeta AS pm1 ON ( p.ID = pm1.post_id AND pm1.meta_key = 'latitude' )
				LEFT JOIN wp_postmeta AS pm2 ON ( p.ID = pm2.post_id AND pm2.meta_key = 'longitude' )
				WHERE post_type = 'directories' AND post_status = 'publish'
				HAVING distance <= $radius
				ORDER BY distance ASC;");
				return $results;
			}
			public function iv_directories_contact_popup(){
				include( wp_iv_directories_template. 'private-profile/contact_popup.php');
				exit(0);
			}
			public function iv_directories_save_favorite(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'contact' ) ) {
					echo json_encode(array("msg"=>"Are you cheating:wpnonce?"));
					exit(0);
				}
				parse_str($_POST['data'], $form_data);
				$dir_id=sanitize_text_field($form_data['id']);
				$old_favorites= get_post_meta($dir_id,'_favorites',true);
				$old_favorites = str_replace(get_current_user_id(), '',  $old_favorites);
				$new_favorites=$old_favorites.', '.get_current_user_id();
				update_post_meta($dir_id,'_favorites',$new_favorites);
				$old_favorites2=get_user_meta(get_current_user_id(),'_dir_favorites', true);
				$old_favorites2 = str_replace($dir_id ,' ',  $old_favorites2);
				$new_favorites2=$old_favorites2.', '.$dir_id;
				update_user_meta(get_current_user_id(),'_dir_favorites',$new_favorites2);
				echo json_encode(array("msg" => 'success'));
				exit(0);
			}
			public function iv_directories_save_un_favorite(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'contact' ) ) {
					echo json_encode(array("msg"=>"Are you cheating:wpnonce?"));
					exit(0);
				}
				parse_str($_POST['data'], $form_data);
				$dir_id=sanitize_text_field($form_data['id']);
				$old_favorites= get_post_meta($dir_id,'_favorites',true);
				$old_favorites = str_replace(get_current_user_id(), '',  $old_favorites);
				$new_favorites=$old_favorites;
				update_post_meta($dir_id,'_favorites',$new_favorites);
				$old_favorites2=get_user_meta(get_current_user_id(),'_dir_favorites', true);
				$old_favorites2 = str_replace($dir_id ,' ',  $old_favorites2);
				$new_favorites2=$old_favorites2;
				update_user_meta(get_current_user_id(),'_dir_favorites',$new_favorites2);
				echo json_encode(array("msg" => 'success'));
				exit(0);
			}
			public function iv_directories_save_note(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'myaccount' ) ) {
					echo json_encode(array("msg"=>"Are you cheating:wpnonce?"));
					exit(0);
				}
				parse_str($_POST['data'], $form_data);
				$dir_id=sanitize_text_field($form_data['id']);
				$note=sanitize_text_field($form_data['note']);
				update_post_meta($dir_id,'_note_'.get_current_user_id(),$note);
				echo json_encode(array("msg" => 'success'));
				exit(0);
			}
			public function iv_directories_delete_favorite(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'myaccount' ) ) {
					echo json_encode(array("msg"=>"Are you cheating:wpnonce?"));
					exit(0);
				}
				parse_str($_POST['data'], $form_data);
				$dir_id=sanitize_text_field($form_data['id']);
				$old_favorites= get_post_meta($dir_id,'_favorites',true);
				$old_favorites = str_replace(get_current_user_id(), '',  $old_favorites);
				$new_favorites=$old_favorites;
				update_post_meta($dir_id,'_favorites',$new_favorites);
				$old_favorites2=get_user_meta(get_current_user_id(),'_dir_favorites', true);
				$old_favorites2 = str_replace($dir_id ,' ',  $old_favorites2);
				$new_favorites2=$old_favorites2;
				update_user_meta(get_current_user_id(),'_dir_favorites',$new_favorites2);
				echo json_encode(array("msg" => 'success'));
				exit(0);
			}
			public function iv_directories_message_send(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'contact' ) ) {
					echo json_encode(array("msg"=>"Are you cheating:wpnonce?"));
					exit(0);
				}
				parse_str($_POST['form_data'], $form_data);
				include( wp_iv_directories_ABSPATH. 'inc/message-mail.php');
				echo json_encode(array("msg" => esc_html__( 'Message Sent', 'ivdirectories' )));
				exit(0);
			}
			public function eppro_upload_featured_image($thumb_url, $post_id ) {
				require_once(ABSPATH . 'wp-admin/includes/file.php');
				require_once(ABSPATH . 'wp-admin/includes/media.php');
				require_once(ABSPATH . 'wp-admin/includes/image.php');
				// Download file to temp location
				$i=0;$product_image_gallery='';
				$tmp = download_url( $thumb_url );
				// Set variables for storage
				// fix file name for query strings
				preg_match('/[^\?]+\.(jpg|JPG|jpe|JPE|jpeg|JPEG|gif|GIF|png|PNG)/', $thumb_url, $matches);
				$file_array['name'] = basename($matches[0]);
				$file_array['tmp_name'] = $tmp;
				// If error storing temporarily, unlink
				if ( is_wp_error( $tmp ) ) {
					@unlink($file_array['tmp_name']);
					$file_array['tmp_name'] = '';
				}
				//use media_handle_sideload to upload img:
				$thumbid = media_handle_sideload( $file_array, $post_id, 'gallery desc' );
				// If error storing permanently, unlink
				if ( is_wp_error($thumbid) ) {
					@unlink($file_array['tmp_name']);
				}
				set_post_thumbnail($post_id, $thumbid);
			}
			public function iv_directories_claim_send(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'contact' ) ) {
					echo json_encode(array("msg"=>"Are you cheating:wpnonce?"));
					exit(0);
				}
				parse_str($_POST['form_data'], $form_data);
				include( wp_iv_directories_ABSPATH. 'inc/claim-mail.php');
				echo json_encode(array("msg" => esc_html__( 'Message Sent', 'ivdirectories' )));
				exit(0);
			}
			public function paging() {
				global $wp_query;
			}
			public function check_write_access($arg=''){
				global $current_user;	global $wpdb;
				$current_user = wp_get_current_user();
				$userId=$current_user->ID;
				if(isset($current_user->roles[0]) and $current_user->roles[0]=='administrator'){
					return true;
				}
				$package_id=get_user_meta($userId,'iv_directories_package_id',true);
				$access=get_post_meta($package_id, 'iv_directories_package_'.$arg, true);
				$sql="SELECT * FROM $wpdb->posts WHERE post_type = 'iv_directories_pack'  and post_status='draft' ";
				$membership_pack = $wpdb->get_results($sql);
				$total_package = count($membership_pack);
				if($total_package<1){
					$access='yes';
				}
				if($access=='yes'){
					return true;
					}else{
					return false;
				}
			}
			public function check_reading_access($arg='',$id=0){
				global $post;
				$current_user = wp_get_current_user();
				$userId=$current_user->ID;
				if($id>0){
					$post = get_post($id);
				}
				if($post->post_author==$userId){
					return true;
				}
				$package_id=get_user_meta($userId,'iv_directories_package_id',true);
				$access=get_post_meta($package_id, 'iv_directories_package_'.$arg, true);
				$active_module=get_option('_iv_directories_active_visibility');
				if($active_module=='yes' ){
					if(isset($current_user->ID) AND $current_user->ID!=''){
						$user_role= $current_user->roles[0];
						if(isset($current_user->roles[0]) and $current_user->roles[0]=='administrator'){
							return true;
						}
						}else{
						$user_role= 'visitor';
					}
					$store_array=get_option('_iv_visibility_serialize_role');
					if(isset($store_array[$user_role]))
					{
						if(in_array($arg, $store_array[$user_role])){
							return true;
							}else{
							return false;
						}
						}else{
						return false;
					}
					}else{
					return true;
				}
			}
		}
	}
	if(!class_exists('WP_GeoQuery'))
	{
		/**
			* Extends WP_Query to do geographic searches
		*/
		class WP_GeoQuery extends WP_Query
		{
			private $_search_latitude = NULL;
			private $_search_longitude = NULL;
			private $_search_distance = NULL;
			private $_search_postcats = NULL;
			/**
				* Constructor - adds necessary filters to extend Query hooks
			*/
			public function __construct($args = array())
			{
				// Extract Latitude
				if(!empty($args['lat']))
				{
					$this->_search_latitude = $args['lat'];
				}
				// Extract Longitude
				if(!empty($args['lng']))
				{
					$this->_search_longitude = $args['lng'];
				}
				if(!empty($args['distance']))
				{
					$this->_search_distance = $args['distance'];
				}
				if(!empty($args['category']))
				{
					$this->_search_postcats= $args['category'];
				}
				// unset lat/lng
				unset($args['lat'], $args['lng'],$args['distance']);
				add_filter('posts_fields', array(&$this, 'posts_fields'), 10, 2);
				add_filter('posts_join', array(&$this, 'posts_join'), 10, 2);
				add_filter('posts_where', array(&$this, 'posts_where'), 10, 2);
				add_filter('posts_groupby', array($this, 'posts_groupby'), 10, 2);
				add_filter('posts_orderby', array(&$this, 'posts_orderby'), 10, 2);
				parent::query($args);
				remove_filter('posts_fields', array($this, 'posts_fields'));
				remove_filter('posts_join', array($this, 'posts_join'));
				remove_filter('posts_where', array($this, 'posts_where'));
				remove_filter('posts_groupby', array($this, 'posts_groupby'));
				remove_filter('posts_orderby', array($this, 'posts_orderby'));
			} // END public function __construct($args = array())
			/**
				* Selects the distance from a haversine formula
			*/
			public function posts_groupby($where) {
				global $wpdb;
				if($this->_search_longitude!=""){
					if($this->_search_postcats!=""){
						$where .= $wpdb->prepare(" HAVING distance < %d ", $this->_search_distance);
						}else{
						$where = $wpdb->prepare("{$wpdb->posts}.ID  HAVING distance < %d ", $this->_search_distance);
					}
				}
				if($this->_search_postcats!=""){
				}
				return $where;
			}
			public function posts_fields($fields)
			{
				global $wpdb;
				if(!empty($this->_search_latitude) && !empty($this->_search_longitude))
				{
					$dir_search_redius=get_option('_dir_search_redius');
					$for_option_redius='6387.7';
					if($dir_search_redius=="Miles"){$for_option_redius='3959';}else{$for_option_redius='6387.7'; }
					$fields .= sprintf(", ( ".$for_option_redius."* acos(
					cos( radians(%s) ) *
					cos( radians( latitude.meta_value ) ) *
					cos( radians( longitude.meta_value ) - radians(%s) ) +
					sin( radians(%s) ) *
					sin( radians( latitude.meta_value ) )
					) ) AS distance ", $this->_search_latitude, $this->_search_longitude, $this->_search_latitude);
					$fields .= ", latitude.meta_value AS latitude ";
					$fields .= ", longitude.meta_value AS longitude ";
				}
				return $fields;
			} // END public function posts_join($join, $query)
			/**
				* Makes joins as necessary in order to select lat/long metadata
			*/
			public function posts_join($join, $query)
			{
				global $wpdb;
				if(!empty($this->_search_latitude) && !empty($this->_search_longitude)){
					$join .= " INNER JOIN {$wpdb->postmeta} AS latitude ON {$wpdb->posts}.ID = latitude.post_id ";
					$join .= " INNER JOIN {$wpdb->postmeta} AS longitude ON {$wpdb->posts}.ID = longitude.post_id ";
				}
				return $join;
			} // END public function posts_join($join, $query)
			/**
				* Adds where clauses to compliment joins
			*/
			public function posts_where($where)
			{
				if(!empty($this->_search_latitude) && !empty($this->_search_longitude)){
					$where .= ' AND latitude.meta_key="latitude" ';
					$where .= ' AND longitude.meta_key="longitude" ';
				}
				return $where;
			} // END public function posts_where($where)
			/**
				* Adds where clauses to compliment joins
			*/
			public function posts_orderby($orderby)
			{
				if(!empty($this->_search_latitude) && !empty($this->_search_distance))
				{
					$orderby = " distance ASC, " . $orderby;
				}
				return $orderby;
			} // END public function posts_orderby($orderby)
		}
	}
	/*
		* Creates a new instance of the BoilerPlate Class
	*/
	function iv_directoriesBootstrap() {
		return wp_iv_directories::instance();
	}
iv_directoriesBootstrap(); ?>
